/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#ifndef _DISABLE_GL_
#include <gl/gl.h>
#include <gl/device.h>
#include <gl/sphere.h>
#endif
#include "symbol.h"
#include "light.h"

int no_of_lights = 1;

#ifndef _DISABLE_GL_
static short light_symbol[8] = {LIGHT0,LIGHT1,LIGHT2,LIGHT3,LIGHT4,LIGHT5,LIGHT6,LIGHT7};
#endif

 light::light()
{
  if (no_of_lights == 9) {
    fprintf(stderr,"Fatal:\nToo many Lights;\n");
    exit(-1);
  }
  type = LIGHT_OBJ;
  light_id = no_of_lights; 
  sym_id = sym_light;
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void light::light ()\n",(unsigned int)this,ref_c);
#endif
  no_of_lights++;
}

void light::RgbSet(float r,float g,float b)
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void light::RgbSet (%g,%g,%g)\n",(unsigned int)this,ref_c,r,g,b);
#endif
  tc_red = r;
  tc_green = g;
  tc_blue = b;
}

float Light[10];
void light::Bind()
{
#ifdef DEBUG
  fprintf(stderr,"this (%x) rc %d void light::Bind ()\n",(unsigned int)this,ref_c);
#endif
#ifndef _DISABLE_GL_
  Light[0] = LCOLOR;
  Light[1] = tc_red;
  Light[2] = tc_green;
  Light[3] = tc_blue;
  Light[4] = POSITION;
  Light[5] = object_location->X();
  Light[6] = object_location->Y();
  Light[7] = object_location->Z();
  Light[8] = 0.1;
  Light[9] = LMNULL;
  lmdef( DEFLIGHT,light_id , 0, Light);
  lmbind(light_symbol[light_id-1],   light_id);
#endif
}


