/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* */
/* -*- C++ -*- */
#include <stdlib.h>
#include <new.h>
#include "object.h"
#include "group.h"
#include "color_obj.h"
#include "node.h"
#include "hash.h"
#include "symbol.h"
#include "group.h"
#include "gorth.h"

short obj_name;
group*  var_list;
material* default_object_color;
location* default_locate;
location* default_rotate;
graphic_orth* orth_obj;
group* root_obj;
group* current_ref_group;
node* back_ground;
node* object_default;
node* root;

void initialize_object()
{
  obj_name = 1;
  var_list = new group[1];
  default_object_color = new material[1];
  default_object_color->Split();
  default_locate = new location[1];
  default_locate->Split();
  default_rotate = new location[1];
  default_rotate->Split();
  root = (node*)(var_list->Search_and_Create(":"));
  if ((root->Value()) == (header*)0) {
    root_obj = new group[1];
    root_obj->Parent((object*)root);
    root_obj->DrawState(ObjectDrawing);
    root->Value(root_obj);
  }
  object_default = (node*)(root_obj->Search_and_Create("DefaultObjectColor"));
  object_default->Value(default_object_color);
  default_object_color->Split();
  back_ground = (node*)(root_obj->Search_and_Create("BackGroundColor"));
  back_ground->Value(default_object_color);
  default_object_color->Split();
  current_ref_group = root_obj;
  node* gonp;
  gonp = (node*)(root_obj->Search_and_Create("GraphicOrth"));
  if ((gonp->Value()) == (header*)0) {
    orth_obj = new graphic_orth[1];
    gonp->Value(orth_obj);
  }
}

header* object::Reference(char* name)
{
  int id;
  id = hash_table.wordId((char*)name);
  return Reference(id);
}

 header* object::Reference(int id)
{
  header* ret;
  ret = (header*)0;
  if (color->Id() == id) {
    ret = (header*)(color);
  }
  return ret;
}

void object::Draw()
{
}

object::object()
{
  scale = 1.0;
  dstate = ObjectHidding;
  color = new node[1];
  color->Id(sym_om_color);
  header* d_color;
  if (object_default != NULL) {
    d_color = object_default->Value();
    color->Value(d_color);
    if (d_color != NULL)d_color->Split();
  }
  object_location = default_locate;
  if (default_locate != NULL) { 
    default_locate->Split();
  }
  object_rotation =   default_rotate; 
  if (default_rotate != NULL) default_rotate->Split();
  obj_id = obj_name;
  obj_name++;
}

void object::CopySplitMember()
{
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Id(color_id);
  color->Value(cv);
}

void object::DrawState(DrawStatus t)
{
  dstate = t;
}

DrawStatus object::DrawState()
{
  return dstate;
}

void object::Move(header* l)
{
  if(object_location != (header*)0) {
    object_location->Close();
  }
  object_location = (location*)l;
  object_location->Split();
}

void object::Location(header* l)
{
#ifdef DEBUG
  fprintf(stderr,"void object::Location(header* %x)\n",(unsigned int)l);
#endif
  if (object_location != (header*)0){
    object_location->Close();
  }
  l->Split();
  object_location = (location*)l;
}
header* object::Location()
{
#ifdef DEBUG
  fprintf(stderr,"header* object::Location()\n");
#endif
  return (header*)object_location;
}

void object::Rotate(header* r)
{
#ifdef DEBUG
  fprintf(stderr,"void object::Rotate(header* %x)\n",(unsigned int)r);
#endif
  if (object_rotation != (header*)0){
    object_rotation->Close();
  }
  r->Split();
  object_rotation = (location*)r;
}

header* object::Rotate()
{
#ifdef DEBUG
  fprintf(stderr,"header* object::Rotate()\n");
#endif
  return (header*)object_rotation;
}

void object::Scale(double s)
{
  fprintf(stderr,"\nError : Illiegal mesage \"scale.\"\n");
}

double object::Scale()
{
  return scale;
}

void object::PushScale()
{
#ifdef DEBUG
  fprintf(stderr,"void object::PushScale()\n");
#endif
#ifndef _DISABLE_GL_
  if ((scale != 0)&&(scale != 1.0)) {
    ::scale(scale,scale,scale);
  }
#endif
}
void object::PopScale()
{
#ifdef DEBUG
  fprintf(stderr,"void object::PopScale()\n");
#endif
#ifndef _DISABLE_GL_
  if ((scale != 0)&&(scale != 1.0)) {
    double inv_scale = 1/scale;
    ::scale(inv_scale,inv_scale,inv_scale);
  }
#endif
}

 void object::PushTranslation()
{
#ifdef DEBUG
  fprintf(stderr,"void object::PushTranslation()\n");
#endif
#ifndef _DISABLE_GL_
  translate((object_location->X()),(object_location->Y()),(object_location->Z()));
#endif
}

 void object::PopTranslation()
{
#ifdef DEBUG
  fprintf(stderr,"void object::PopTranslation()\n");
#endif
#ifndef _DISABLE_GL_
  translate(-(object_location->X()),-(object_location->Y()),-(object_location->Z()));
#endif
}

 void object::PushRotation()
{
#ifdef DEBUG
  fprintf(stderr,"void object::PushRotation()\n");
#endif
#ifndef _DISABLE_GL_
  rot((object_rotation->X()),'x');
  rot((object_rotation->Y()),'y');
  rot((object_rotation->Z()),'z');
#endif
}

void object::PopRotation()
{
#ifdef DEBUG
  fprintf(stderr,"void object::PopRotation()\n");
#endif
#ifndef _DISABLE_GL_
  rot(-(object_rotation->Z()),'z');
  rot(-(object_rotation->Y()),'y');
  rot(-(object_rotation->X()),'x');
#endif
}

void object::From(location* l)
{
    fprintf(stderr,"\nError : Illiegal mesage \"from.\"\n");
}
 
void object::To(location* l)
{
    fprintf(stderr,"\nError : Illiegal mesage \"to.\"\n");
}

void object::AliasState(char* str)
{
  fprintf(stderr,"\nError : Illiegal mesage \"antialias.\"\n");
}

void object::Nurbs(char* str)
{
  fprintf(stderr,"\nError : Illiegal mesage \"nurbs.\"\n");
}
