/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* */
/* -*-C++-*- */
#ifndef _primitive_h_

#define _primitive_h_
#ifndef _node_h_
#include "node.h"
#endif
#ifndef _object_h_
#include "object.h"
#endif

/* Begin Class Definition dot */
class graphic_primitive : public object {
 protected:
  unsigned char anti_alias; 
  unsigned char smooth;     
 public:
  graphic_primitive();
  void AliasState(char* str);
  void SmoothState(char* str);
  char* AliasState();
  char* SmoothState();

/* virtual Function. Look object.h */
  void Scale(double s);
};

class dot : public graphic_primitive {
 public:
  void Close();
  dot();
/* virtual Function. Look object.h */
  void Draw();
#ifdef _UN_USE_YACC_
#include "accept.h"
#include "reduce.h"
#endif
};
/* End Class Definition dot */

/* Begin Class Definition segment */
class segment : public graphic_primitive {
  float dx,dy,dz;
  node style[1];
  node width[1];
 public:
  segment();
  void Close();
  header* Reference(int id);
  void From(location* t);
  void To(location* t);
  void Draw();
  void CopySplitMember();
#ifdef _UN_USE_YACC_
#include "accept.h"
#include "reduce.h"
#endif
};
/* End Class Definition segment */

/* Begin Class Definition line */
class line : public graphic_primitive {
  int is_nurbs;
  int no_of_points;
  node style[1];
  node width[1];
  node points[1];
 public:
  line();
  header* Reference(int id);
  void Close();
  void Width(int t); 
  void Draw();
  void Nurbs(char* str);
  char* Nurbs();
  void CopySplitMember();
#ifdef _UN_USE_YACC_
#include "accept.h"
#include "reduce.h"
#endif
};
/* End Class Definition line */

/* Begin Class Definition mesh */
class mesh : public graphic_primitive {
 protected:
  int is_nurbs;
  int no_of_points;
  node points[1];
 public:
  mesh();
  void Nurbs(char* str);
  char* Nurbs();

  header* Reference(int id);
  void CopySplitMember();
  void Close();
  void Draw();
#ifdef _UN_USE_YACC_
#include "accept.h"
#include "reduce.h"
#endif
} ;
/* End Class Definition mesh */

#endif


