/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifdef _UN_USE_YACC_
#include <math.h>
#include "group.h"
#include "sphere.h"
#include "cylinder.h"
#include "primitive.h"
#include "box.h"
#include "exit.h"
#include "text.h"
#include "color_obj.h"
#include "light.h"
#include "data.h"
#include "hash.h"
#include "symbol.h"
#include "messagetag.h"
#include "gorth.h"

extern group* root_obj;
extern group* current_ref_group;
extern int is_sync;
extern group* group_stack[GROUP_STACK_SIZE];
extern int group_sp;
extern graphic_orth* orth_obj;
extern inline void error_exit();
extern header* insert_list(header* top,header*tail);
extern header*  append_list(header* last,header* list);

PReduce(header)
{
  return (header*)0;
}

PReduce(location) 
{
  switch(mid) {
  case METHOD_VALUE:
    fixed_number* fnum;
    fnum = (fixed_number*)args;
    header* anext;
    anext = args->Next();
    int index = fnum->Value();
    if (anext == (header*)0) {
      if(index == 0) {
	return create_float(value[0]);
      }else if(index == 1){
	return create_float(value[1]);
      }else{
	return create_float(value[2]);
      }
    }else{
      double wvalue ;
      if (anext->Type() == DAT_INTEGER) {
	wvalue = (double)((fixed_number*)anext)->Value();
      }else{
	wvalue = ((float_number*)anext)->Value();
      }
      if(index == 0) {
	value[0] = wvalue;
      }else if(index == 1){
	value[1] = wvalue;
      }else{
	value[2] = wvalue;
      }
    }
  default:
    return (header*)0;
  }
}

PReduce(cons) 
{
  header* ret;
  ret = (header*)0;
  switch (mid) {
  case METHOD_APPEND:
    return append_list(this,args);
  case METHOD_ELEMENT:
    fixed_number* index;
    index = (fixed_number*)args;
    int elmnt = index->Value();
    cons* wp;
    wp = this;
    for (int count = 0;count < elmnt;count++) {
      if (wp != (header*)0) return (header*)0;
      wp = (cons*)wp->Cdr();
    }
    if (args->Next() == NULL) {
      return (wp->Car());
    }else{
      header* dp;
      dp = wp->Car();
      if (dp != (header*)0)dp->Close();
      args->Split();
      wp->Car(args);
    }
    return ret;
  case METHOD_INSERT:
    return insert_list(args,this);
  case METHOD_CAR:
    return car;
  case METHOD_CDR:
    return cdr;
  default:
    return ret;
  }
}

PReduce(graphic_orth) 
{
  if (mid == METHOD_TRANSFORM) {
    float var_arg[6];
    header* wp = args;
    for (int arg_c = 0;arg_c<6;arg_c++) {
      if (wp->Type() == DAT_INTEGER) {
	var_arg[arg_c] = (float)(((fixed_number*)wp)->Value());
      }else if(wp->Type() == DAT_FLOAT) {
	var_arg[arg_c] = ((float_number*)wp)->Value();
      }
      wp = wp->Next();
    }
    Transform(var_arg[0],var_arg[1],var_arg[2],var_arg[3],var_arg[4],var_arg[5]);
    return (header*)this;
  }
  return (header*)0;
}

PReduce(material) 
{
  location* larg;
  switch(mid) {
  case METHOD_BIND:
    Bind();
    return (header*)this;
  case METHOD_SHINES:
    if (args->Type() == DAT_INTEGER) {
      Shiness((float)(((fixed_number*)args)->Value()));
    }else if (args->Type() == DAT_FLOAT) {
      Shiness(((float_number*)args)->Value());
    }
    return (header*)this;
  case METHOD_ALPHA:
    if (args->Type() == DAT_INTEGER) {
      Alpha((float)(((fixed_number*)args)->Value()));
    }else  if (args->Type() == DAT_FLOAT) {
      Alpha(((float_number*)args)->Value());
    }
    return (header*)this;
  case METHOD_SPECULER:
    larg = (location*)args;
    Speculer(larg->X(),larg->Y(),larg->Z());
    return (header*)this;
  case METHOD_COLOR:
    larg = (location*)args;
    RgbSet(larg->X(),larg->Y(),larg->Z());
    return (header*)this;
  default:
    return (header*)0;
  }
}

PReduce(light) 
{
  switch(mid) {
  case METHOD_BIND:
    Bind();
    return (header*)this;
  case METHOD_COLOR:
    location* colors_arg;
    colors_arg = (location*)args;
    RgbSet(colors_arg->X(),colors_arg->Y(),colors_arg->Z());
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  default:
    return (header*)0;
  }
}

PReduce(node) 
{
  if (mid == METHOD_DELETE) {
    if (value_object != (header*)0) {
      value_object->Close();
    }
    value_object = (header*)0;
    return value_object;
  }else if (mid == METHOD_SYNC) {
    is_sync = TRUE;
  }else if (mid == METHOD_PUSH){
    if (args->Type() == GROUP_OBJ) {
      if (group_sp < GROUP_STACK_SIZE) {
	group_stack[group_sp] = current_ref_group;
	group_sp++;
      }
      current_ref_group = (group*)args;
    }
  }else if(mid == METHOD_QUIT){
    normal_exit() ;
  }else if(mid == METHOD_POP){
    if (group_sp > 0) {
      group_sp--;
      current_ref_group =  group_stack[group_sp];
    }
  }else if(mid == METHOD_INTO){
    if (args->Type() == GROUP_OBJ) {
      current_ref_group = (group*)args;
    }
  }else if(mid == METHOD_UP){
    if (current_ref_group != root_obj) {
      node* work;
      work = (node*)(current_ref_group->Parent());
      current_ref_group = (group*)(work->Parent());
    }
  }else if (mid == METHOD_INSERT) {
    if (value_object == (header*)0) {
      return ::insert_list(args,(header*)0);
    }
    return value_object->Reduce(mid,args);
  }else if (mid == METHOD_IS) {
    if (value_object != (header*)0) {
      value_object->Close();
    }
    Value(args);
    if (args != (header*)0) {
      if (((args->Type()) == GROUP_OBJ)&&((((group*)args)->Parent()) == (header*)0)) {
	((group*)args)->Parent((header*)this);
      }
      value_object->Split();
    }
    return value_object;
  }else if (mid == METHOD_COPY) {
    if (value_object != (header*)0) {
      value_object->Close();
    }
    Value(::copy_object(args));
    if (value_object != (header*)0)value_object->Split();
    return value_object;
  }else if (value_object == (header*)0) {
    return (header*)0;
  }
  return value_object->Reduce(mid,args);
}

PReduce(group) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_DRAW_ALL:
    DrawStateAll(ObjectDrawing);
    return (header*)this;
  case METHOD_HIDE_ALL:
    DrawStateAll(ObjectHidding);
    return (header*)this;
  case METHOD_WIRE_ALL:
    DrawStateAll(DrawingWireFrame);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  default:
    break;
  }
  return (header*)0;
}

PReduce(sphere) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  default:
    break;
  }
  return (header*)0;
}

PReduce(dot) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  case METHOD_ANTIALIASES:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    AliasState(((string*)args)->Value());
    return (header*)this;
  case METHOD_SMOOTHS:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    SmoothState(((string*)args)->Value());
    return (header*)this;
  default:
    break;
  }
  return (header*)0;
}

PReduce(segment) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  case METHOD_FROM:
    From((location*)args);
    return (header*)this;
  case METHOD_TO:
    To((location*)args);
    return (header*)this;
  case METHOD_ANTIALIASES:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    AliasState(((string*)args)->Value());
    return (header*)this;
  case METHOD_SMOOTHS:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    SmoothState(((string*)args)->Value());
    return (header*)this;
  default:
    break;
  }
  return (header*)0;
}

PReduce(mesh) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_NURBS:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    Nurbs(((string*)args)->Value());
    return (header*)this;
  case METHOD_ANTIALIASES:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    AliasState(((string*)args)->Value());
    return (header*)this;
  case METHOD_SMOOTHS:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    SmoothState(((string*)args)->Value());
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  default:
    break;
  }
  return (header*)0;
}

PReduce(line) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  case METHOD_NURBS:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    Nurbs(((string*)args)->Value());
    return (header*)this;
  case METHOD_ANTIALIASES:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    AliasState(((string*)args)->Value());
    return (header*)this;
  case METHOD_SMOOTHS:
    if (args->Type() != DAT_STRING) {
      fprintf(stderr,"Fatal :\n is not symbol\n");
      ::error_exit();
    }
    SmoothState(((string*)args)->Value());
    return (header*)this;
  default:
    break;
  }
  return (header*)0;
}

PReduce(text) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  default:
    break;
  }
  return (header*)0;
}

PReduce(box) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_TO:
    To((location*)args);
    return (header*)this;
  case METHOD_FROM:
    From((location*)args);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  default:
    break;
  }
  return (header*)0;
}

PReduce(cylinder) 
{
  switch (mid) {
  case METHOD_SCALE:
    double s;
    if (args->Type() == DAT_INTEGER)  {
      s = (double)((fixed_number*)args)->Value();
    }else{
      s = ((float_number*)args)->Value();
    }
    Scale(s);
    return (header*)this;
  case METHOD_TO:
    To((location*)args);
    return (header*)this;
  case METHOD_FROM:
    From((location*)args);
    return (header*)this;
  case METHOD_DRAW:
    dstate = ObjectDrawing;
    return (header*)this;
  case METHOD_HIDE:
    dstate = ObjectHidding;
    return (header*)this;
  case METHOD_WIRE:
    dstate = DrawingWireFrame;
    return (header*)this;
  case METHOD_MOVE:
    Move(args);
    return (header*)this;
  case METHOD_ROTATE:
    Rotate(args);
    return (header*)this;
  case METHOD_LOCATION:
    return (header*)object_location;
  case METHOD_ROTATION:
    return (header*)object_rotation;
  default:
    break;
  }
  return (header*)0;
}

#endif /*_UN_USE_YACC_*/
