/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <math.h>
#include "vect.h"
#include "trackball.h"

#define TRACKBALLSIZE  (0.8)
#define RENORMCOUNT 97

void normalize_quat(float q[4])
{
  int i;
  float mag;
  mag = (q[0]*q[0] + q[1]*q[1] + q[2]*q[2] + q[3]*q[3]);
  for (i = 0; i < 4; i++) q[i] /= mag;
}

float tb_project_to_sphere(float r, float x, float y)
{
  float d, t, z;
  d = sqrt(x*x + y*y);
  if (d < r*M_SQRT1_2){
    z = sqrt(r*r - d*d);
  } else {
    t = r / M_SQRT2;
    z = t*t / d;
  }
  return z;
}

void trackball(float q[4], float p1x, float p1y, float p2x, float p2y)
{
  float a[3];
  float phi;
  float p1[3], p2[3], d[3];
  float t = 0;
  if (p1x == p2x && p1y == p2y) {
    q[0] = 0; q[1] = 0; q[2] = 0;
    q[3] = 1.0;
    return;
  }
  d[0] = p1[0] = p1x;  
  d[1] = p1[1] = p1y;  
  d[2] = p1[2] = tb_project_to_sphere(TRACKBALLSIZE,p1x,p1y);
  p2[0] = p2x;
  p2[1] = p2y;
  p2[2] = tb_project_to_sphere(TRACKBALLSIZE,p2x,p2y);
  d[0] -= p2x;
  d[1] -= p2y;
  d[2] -= p2[2];
  vcross(p2,p1,a);
  t = vlength(d) / (2.0*TRACKBALLSIZE);
  if (t > 1.0) t = 1.0;
  if (t < -1.0) t = -1.0;
  phi = 2.0 * asin(t);
  axis_to_quat(a,phi,q);
}

void axis_to_quat(float a[3], float phi, float q[4])
{
  float h_phi = phi/2.0;
  float sin_phi = sin(h_phi);
  vnormal(a);
  q[0] = a[0]*sin_phi;  q[1] = a[1]*sin_phi;  q[2] = a[2]*sin_phi;
  q[3] = cos(h_phi);
}

void add_quats(float q1[4], float q2[4], float dest[4])
{
  static int count=0;
  float t1[4];
  float tf[4];
  float q23 = q2[3];  
  float q13 = q1[3];
  tf[0] = q1[0]*q23 + q2[0]*q13;
  tf[1] = q1[1]*q23 + q2[1]*q13;
  tf[2] = q1[2]*q23 + q2[2]*q13;
  vcross(q2,q1,t1);
  tf[0] += t1[0]; tf[1] += t1[1]; tf[2] += t1[2];
  tf[3] = q13 * q23 - (q1[0]*q2[0]+q1[1]*q2[1]+q1[2]*q2[2]);
  dest[0] = tf[0];
  dest[1] = tf[1];
  dest[2] = tf[2];
  dest[3] = tf[3];
  if (++count > RENORMCOUNT) {
    count = 0;
    normalize_quat(dest);
  }
}

void build_rotmatrix(float m[4][4], float q[4])
{
#ifdef _fp_offset_
  float q0mq0 = q[0]*q[0];
  float q0mq1 = q[0]*q[1];
  float q0mq3 = q[0]*q[3];
  float q1mq1 = q[1]*q[1];
  float q1mq2 = q[1]*q[2];
  float q1mq3 = q[1]*q[3];
  float q2mq0 = q[2]*q[0];
  float q2mq2 = q[2]*q[2];
  float q2mq3 = q[2]*q[3];
#else
#define q0mq0 (q[0]*q[0]) 
#define q0mq1 (q[0]*q[1]) 
#define q0mq3 (q[0]*q[3]) 
#define q1mq1 (q[1]*q[1]) 
#define q1mq2 (q[1]*q[2]) 
#define q1mq3 (q[1]*q[3]) 
#define q2mq0 (q[2]*q[0]) 
#define q2mq2 (q[2]*q[2]) 
#define q2mq3 (q[2]*q[3])
#endif
  m[0][0] = m[1][1] = m[2][2] = m[3][3] = 1.0;
  m[3][0] =  m[3][1] =  m[3][2] = 0.0;
  m[0][3] =  m[1][3] =  m[2][3] = 0.0;

  m[0][0] -= 2.0 * (q1mq1 + q2mq2);
  m[0][1] = 2.0 * (q0mq1 - q2mq3);
  m[0][2] = 2.0 * (q2mq0 + q1mq3);

  m[1][0] = 2.0 * (q0mq1 + q2mq3); 
  m[1][1] -= 2.0 * (q2mq2 + q0mq0);
  m[1][2] = 2.0 * (q1mq2 - q0mq3);

  m[2][0] = 2.0 * (q2mq0 - q1mq3);
  m[2][1] = 2.0 * (q1mq2 + q0mq3);
  m[2][2] -= 2.0 * (q1mq1 + q0mq0);

}


