/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "amino.h"

double AminoCharge[] =
{
  0.0,//X

  0.0,//A
  0.0,//C
  0.0,//D
  0.0,//E
  0.0,//F
    
  0.0,//G
  0.0,//H
  0.0,//I
  0.0,//K
  0.0,//L

  0.0,//M
  0.0,//N
  0.0,//P
  0.0,//Q
  0.0,//R

  0.0,//S
  0.0,//T
  0.0,//V
  0.0,//W
  0.0 //Y
};
double AminoHPhobe[] =
{
  0.0,//X

  0.0,//A
  0.0,//C
  0.0,//D
  0.0,//E
  0.0,//F

  0.0,//G
  0.0,//H
  0.0,//I
  0.0,//K
  0.0,//L

  0.0,//M
  0.0,//N
  0.0,//P
  0.0,//Q
  0.0,//R

  0.0,//S
  0.0,//T
  0.0,//V
  0.0,//W
  0.0 //Y
};
double AminoVolume[] =
{
  0.0,//X

  0.0,//A
  0.0,//C
  0.0,//D
  0.0,//E
  0.0,//F

  0.0,//G
  0.0,//H
  0.0,//I
  0.0,//K
  0.0,//L

  0.0,//M
  0.0,//N
  0.0,//P
  0.0,//Q
  0.0,//R

  0.0,//S
  0.0,//T
  0.0,//V
  0.0,//W
  0.0 //Y
};


amino::amino(void)
{
  Triplet[0]='-';
  Triplet[1]='-';
  Triplet[2]='-';
  Triplet[3]='\0';
  Single = '-';
  ID = 0;
}

amino::amino(char* T)
{
  Triplet[0] = T[0];
  Triplet[1] = T[1];
  Triplet[2] = T[2];
  Triplet[3] = '\0';
  if(     0==strncmp(Triplet,"ALA",3)) {Single = 'A';ID = 1;}
  else if(0==strncmp(Triplet,"CYS",3)) {Single = 'C';ID = 2;}
  else if(0==strncmp(Triplet,"ASP",3)) {Single = 'D';ID = 3;}
  else if(0==strncmp(Triplet,"GLU",3)) {Single = 'E';ID = 4;}
  else if(0==strncmp(Triplet,"PHE",3)) {Single = 'F';ID = 5;}
  else if(0==strncmp(Triplet,"GLY",3)) {Single = 'G';ID = 6;}
  else if(0==strncmp(Triplet,"HIS",3)) {Single = 'H';ID = 7;}
  else if(0==strncmp(Triplet,"ILE",3)) {Single = 'I';ID = 8;}
  else if(0==strncmp(Triplet,"LYS",3)) {Single = 'K';ID = 9;}
  else if(0==strncmp(Triplet,"LEU",3)) {Single = 'L';ID = 10;}
  else if(0==strncmp(Triplet,"MET",3)) {Single = 'M';ID = 11;}
  else if(0==strncmp(Triplet,"ASN",3)) {Single = 'N';ID = 12;}
  else if(0==strncmp(Triplet,"PRO",3)) {Single = 'P';ID = 13;}
  else if(0==strncmp(Triplet,"GLN",3)) {Single = 'Q';ID = 14;}
  else if(0==strncmp(Triplet,"ARG",3)) {Single = 'R';ID = 15;}
  else if(0==strncmp(Triplet,"SER",3)) {Single = 'S';ID = 16;}
  else if(0==strncmp(Triplet,"THR",3)) {Single = 'T';ID = 17;}
  else if(0==strncmp(Triplet,"VAL",3)) {Single = 'V';ID = 18;}
  else if(0==strncmp(Triplet,"TRP",3)) {Single = 'W';ID = 19;}
  else if(0==strncmp(Triplet,"TYR",3)) {Single = 'Y';ID = 20;}
  else {Single = 'X';ID = 0;}
} 

amino::amino(char S)
{
  Single = S;
  Triplet[3] = '\0';
  switch(S)
    {
    case 'A': strcpy(Triplet,"ALA");ID = 1;break;
    case 'C': strcpy(Triplet,"CYS");ID = 2;break;
    case 'D': strcpy(Triplet,"ASP");ID = 3;break;
    case 'E': strcpy(Triplet,"GLU");ID = 4;break;
    case 'F': strcpy(Triplet,"PHE");ID = 5;break;
    case 'G': strcpy(Triplet,"GLY");ID = 6;break;
    case 'H': strcpy(Triplet,"HIS");ID = 7;break;
    case 'I': strcpy(Triplet,"ILE");ID = 8;break;
    case 'K': strcpy(Triplet,"LYS");ID = 9;break;
    case 'L': strcpy(Triplet,"LEU");ID = 10;break;
    case 'M': strcpy(Triplet,"MET");ID = 11;break;
    case 'N': strcpy(Triplet,"ASN");ID = 12;break;
    case 'P': strcpy(Triplet,"PRO");ID = 13;break;
    case 'Q': strcpy(Triplet,"GLN");ID = 14;break;
    case 'R': strcpy(Triplet,"ARG");ID = 15;break;
    case 'S': strcpy(Triplet,"SER");ID = 16;break;
    case 'T': strcpy(Triplet,"THR");ID = 17;break;
    case 'V': strcpy(Triplet,"VAL");ID = 18;break;
    case 'W': strcpy(Triplet,"TRP");ID = 19;break;
    case 'Y': strcpy(Triplet,"TYR");ID = 20;break;
    default:  strcpy(Triplet,"***");ID = 0;
    }
}

amino::amino(int I)
{
  ID = I;
  Triplet[3] = '\0';
  switch(ID)
    {
    case  1: Single = 'A'; strcpy(Triplet,"ALA");break;
    case  2: Single = 'C'; strcpy(Triplet,"CYS");break;
    case  3: Single = 'D'; strcpy(Triplet,"ASP");break;
    case  4: Single = 'E'; strcpy(Triplet,"GLU");break;
    case  5: Single = 'F'; strcpy(Triplet,"PHE");break;
    case  6: Single = 'G'; strcpy(Triplet,"GLY");break;
    case  7: Single = 'H'; strcpy(Triplet,"HIS");break;
    case  8: Single = 'I'; strcpy(Triplet,"ILE");break;
    case  9: Single = 'K'; strcpy(Triplet,"LYS");break;
    case 10: Single = 'L'; strcpy(Triplet,"LEU");break;
    case 11: Single = 'M'; strcpy(Triplet,"MET");break;
    case 12: Single = 'N'; strcpy(Triplet,"ASN");break;
    case 13: Single = 'P'; strcpy(Triplet,"PRO");break;
    case 14: Single = 'Q'; strcpy(Triplet,"GLN");break;
    case 15: Single = 'R'; strcpy(Triplet,"ARG");break;
    case 16: Single = 'S'; strcpy(Triplet,"SER");break;
    case 17: Single = 'T'; strcpy(Triplet,"THR");break;
    case 18: Single = 'V'; strcpy(Triplet,"VAL");break;
    case 19: Single = 'W'; strcpy(Triplet,"TRP");break;
    case 20: Single = 'Y'; strcpy(Triplet,"TYR");break;
    default: Single = 'X'; strcpy(Triplet,"***");
    }
}

amino operator=(amino& A,amino& B)
{
  A.Triplet[0]=  B.Triplet[0];
  A.Triplet[1]=  B.Triplet[1];
  A.Triplet[2]=  B.Triplet[2];
  A.Triplet[3]=  B.Triplet[3];
  A.Single    =  B.Single;
  A.ID        =  B.ID;
  return A;
}
