/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <string.h>

class localID
{
  char* RuleName;
  int   FullCnt;
  int   StartPoint;
  int   Width;
  int*  Name;
 public:
  inline localID(int W,char* RN)
    {
      FullCnt    =  0;
      Width      =  W;
      StartPoint = -1;
      Name  = new int[Width];
      for(int I=0;I<Width;++I)
	{
	  Name[I] = 0;
	}
      RuleName   = new char[strlen(RN)+1];
      strcpy(RuleName,RN);
    }
  inline ~localID(void)         {delete Name;}
  inline int  fullCnt(void)     {return FullCnt;};
  inline int  name(int I)
    {
      if(FullCnt<Width)
	{
	  return Name[I];
	}
      else
	{
	  return Name[(StartPoint+I+1)%Width];
	}
    }
  inline void input(int O,int N)
    {
      FullCnt++;
      if(StartPoint < Width-1)
	{
	  StartPoint++;
	}
      else
	{
	  StartPoint = 0;
	}
      Name[StartPoint] = N;
    }
  void hrule(void);
  void vrule(int,int);
};

