/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <ctype.h>
#include <stdio.h>
#include <stream.h>
#include <GetOpt.h>
#include <String.h>
#include "matrix.h"
#include "multivar.h"


char Ccode[] = "0123456789ABCDEF";

int WordFlag = 0;
int PValFlag = 0;
int IndxFlag = 0;
int BuffFlag = 0;

void quantize(multivar& Multivar,String Field[])
{
  int NumElem=Multivar.numElem();
  double FieldVal[NumElem];

  matrix OrigVal(1,NumElem);
  double PValVal[NumElem];
  char   Qcode[NumElem+1];

  Qcode[NumElem] = '\0';

  for(int I=0;I<NumElem;++I)
    {
      FieldVal[I]  = atof(Field[Multivar.statistic(I).id()]);
      OrigVal(0,I) = FieldVal[I] - Multivar.statistic(I).mean();
    }
  for(int P=0;P<NumElem;++P)
    {
      PValVal[P]  = (OrigVal*(Multivar.principal(P).axis()))(0,0);
      PValVal[P] /= sqrt(Multivar.totalVar());
      int Qdata   = int((PValVal[P]+3.75)*2.0);
      Qdata       = (Qdata>0? (Qdata>15?15:Qdata):0);
      Qcode[P] = Ccode[Qdata];
    }
  if(WordFlag)
    {
      printf(" %s",Qcode);
    }
  if(PValFlag)
    {
      for(P=0;P<NumElem;++P)
	{
	  printf(" %10.5f",PValVal[P]);
	}
    }
}

main(int argc, char** argv)
{
  GetOpt getopt (argc, argv, "wpibx");

  int Ch;
  while((Ch=getopt())!=EOF)
    {
      switch(char(Ch))
	{
	case 'w':
	  WordFlag = 1;
	  break;
	case 'p':
	  PValFlag = 1;
	  break;
	case 'i':
	  IndxFlag = 1;
	  break;
	case 'b':
	  BuffFlag = 1;
	  break;
	case 'x':
	  WordFlag = PValFlag = BuffFlag = 1;
	  break;
	default:
	  exit(1);
	}
    }

  multivar Multivar;
  if (getopt.optind < argc)
    {
      Multivar.get(argv[getopt.optind]);
    }
  else
    {
      cerr << "Usage\n\thist StatFile -[cg]\n";
      exit(0);
    }

  FILE* DataFile;
  if(NULL==(DataFile=fopen(Multivar.dataFileName(),"r")))
    {
      cerr << form("Can't open Data File %s\n",Multivar.dataFileName());
      exit(1);
    }

  char   Buff[1024];
  while(fgets(Buff,1023,DataFile))
    {
      if(Buff[0]=='#')
	{
	  puts(Buff);
	  continue;
	}
      String Field[32];
      int NW = getField(Buff,Field);
      if(IndxFlag)
	{
	  printf(" %4d",atoi(Field[0]));
	}
      quantize(Multivar,Field);
      if(BuffFlag)
	{
	  printf(Buff);
	}
      printf("\n");
    }
  fclose(DataFile);
}

