/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stream.h>
#include "field.h"
#include "localID.h"


int beginCheck(FILE* File)
{
  char    Buff[1024];
  int Width;

  if(NULL==fgets(Buff,1023,File))
    return 0;
  if(0==strncmp(Buff,"#Width",6))
    {
      sscanf(Buff+8,"%d",&Width);
    }
  else
    {
      return 0;
    }
  if(NULL==fgets(Buff,1023,File))
    return 0;
  if(0!=strncmp(Buff,"#Begin",6))
    return 0;
  return Width;
}

int vruleCalc(int FieldID, char* RuleName, FILE* LargeFile, FILE* SmallFile)
{
  int    SmallWidth;
  int    LargeWidth;
  char   LargeBuff[1024];
  char   SmallBuff[1024];
  String LargeField[32];
  String SmallField[32];

  if(0 == (SmallWidth = beginCheck(SmallFile)))
    {
      return 0;
    }
  if(0 == (LargeWidth = beginCheck(LargeFile)))
    {
      return 0;
    }

  int LargeNW;
  int SmallNW;

  int LocalWidth =  LargeWidth-SmallWidth+1;

  localID LocalID(LocalWidth,RuleName);

  for(int I=0;I<LocalWidth-1;++I)
    {
      if(NULL == fgets(SmallBuff,1023,SmallFile))
	{
	  return 0;
	}
      if(0==strncmp(SmallBuff,"#End",4))
	{
	  while(1)
	    {
	      if(NULL==fgets(LargeBuff,1023,LargeFile))
		{
		  return 0;
		}
	      if(0==strncmp(LargeBuff,"#End",4))
		{
		  break;
		}
	    }
	  return 1;
	}
      SmallNW = getField(SmallBuff,SmallField);

      LocalID.input(atoi(SmallField[0]),
		    (int)strtol(SmallField[FieldID],(char**)NULL,16));
    }

  while(fgets(LargeBuff,1023,LargeFile))
    {
      if(0==strncmp(LargeBuff,"#End",4))
	{
	  while(1)
	    {
	      if(NULL==fgets(SmallBuff,1023,SmallFile))
		{
		  return 0;
		}
	      if(0==strncmp(SmallBuff,"#End",4))
		{
		  break;
		}
	    }
	  return 1;
	}
      else
	{
	  fgets(SmallBuff,1023,SmallFile);
	}
      LargeNW = getField(LargeBuff,LargeField);
      SmallNW = getField(SmallBuff,SmallField);

      LocalID.input(atoi(SmallField[0]),
		    (int)strtol(SmallField[FieldID],(char**)NULL,16));
      LocalID.vrule(LargeWidth,
		    (int)strtol(LargeField[FieldID],(char**)NULL,16));
    }
  return 0;
}

main(int argc, char** argv)
{
  if(argc <5)
    {
      cerr << "Usage:\nvrule FieldID RuleName LargeFile SmallFile\n";
      exit(1);
    }
  FILE* LargeFile;
  FILE* SmallFile;

  if(NULL==(LargeFile=fopen(argv[3],"r")))
    {
      cerr << form("Can't open LargeFile %s\n",argv[1]);
    }
  if(NULL==(SmallFile=fopen(argv[4],"r")))
    {
      cerr << form("Can't open SmallFile %s\n",argv[1]);
    }

  while(vruleCalc(atoi(argv[1]),argv[2],LargeFile,SmallFile)){}
}
