expand_clause(C0,C) :-
    numbervars(C0,0,N0),
    dlclause(C0,C1,N0,N),
    functor(Vars,$,N),
    reconstruct(C1,Vars,C).

dlclause((H0:-G0|B0),(H:-G|B),N0,N) :- !,
    dlclause(H0,G0,B0,H,G,B,N0,N,V,V).
dlclause((H0:-B0),(H:-G|B),N0,N) :- !,
    dlclause(H0,true,B0,H,G,B,N0,N,V,V).
dlclause((H0),(H:-G|B),N0,N) :-
    dlclause(H0,true,true,H,G,B,N0,N,V,V).

dlclause(H0-'$VAR'(I),G0,B0,H,G,B,N0,N,V,[I|V0]) :- !,
    dlclause(H0,G0,B0,H,G,B,N0,N,V,V0).
dlclause(H0,G0,B0,H,G,B,N0,N,V,[]) :-
    initialize_info(V,N0,N1,[],Vinfo1,Vars),
    H0=..[F|L0], append(L0,Vars,L), H=..[F|L],
    dlgoals(G0,G,N1,N2,Vinfo1,Vinfo2),
    dlgoals(B0,B1,N2,N,Vinfo2,Vinfo3),
    finalize_vars(Vars,Vinfo3,B1,B).

initialize_info([],N,N,Vinfo,Vinfo,[]).
initialize_info([I|T],N0,N,Vinfo0,Vinfo,['$VAR'(J),'$VAR'(N0)|V]) :-
    ( assoc(Vinfo0,I,J) -> true; J=I ),
    N1 is N0+1,
    initialize_info(T,N1,N,[I=J|Vinfo0],Vinfo,V).

finalize_vars([],_,B,B).
finalize_vars(['$VAR'(I),'$VAR'(J)|VF],Info,B0,B) :-
    assoc(Info,I,K),
    finalize_vars(VF,Info,('$VAR'(J)='$VAR'(K),B0),B).

dlgoals((X0,Y0),(X,Y),N0,N,Vinfo0,Vinfo) :- !,
    dlgoals(X0,X,N0,N1,Vinfo0,Vinfo1),
    dlgoals(Y0,Y,N1,N,Vinfo1,Vinfo).
dlgoals(X0,X,N0,N,Vinfo0,Vinfo) :-
    dlgoal(X0,X,N0,N,Vinfo0,Vinfo,V,V).

dlgoal(X0-'$VAR'(I),X,N0,N,Vinfo0,Vinfo,V,[I|V0]) :- !,
    dlgoal(X0,X,N0,N,Vinfo0,Vinfo,V,V0).
dlgoal(X0,X,N0,N,Vinfo0,Vinfo,V,[]) :-
    replace_vars(X0,Vinfo0,X1),
    update_info(V,N0,N,Vinfo0,Vinfo,Vars),
    X1=..[F|L0], append(L0,Vars,L), X=..[F|L].

update_info([],N,N,Vinfo,Vinfo,[]).
update_info([I|T],N0,N,Vinfo0,Vinfo,['$VAR'(J),'$VAR'(N0)|V]) :-
    ( assoc(Vinfo0,I,J) -> true; J=I ),
    N1 is N0+1,
    update_info(T,N1,N,[I=N0|Vinfo0],Vinfo,V).

replace_vars('$VAR'(K),Vinfo,'$VAR'(J)) :- !,
    ( assoc(Vinfo,K,J) -> true; J=K ).
replace_vars([],_,[]) :- !.
replace_vars([H0|T0],Vinfo,[H|T]) :- !,
    replace_vars(H0,Vinfo,H),
    replace_vars(T0,Vinfo,T).
replace_vars(X0,Vinfo,X) :-
    X0=..[F|A0],
    replace_vars(A0,Vinfo,A),
    X=..[F|A].

reconstruct((H0:-true|true),Vars,H) :- !, revar(H0,Vars,H).
reconstruct((H0:-true|B0),Vars,X) :- !, revar((H0:-B0),Vars,X).
reconstruct((H0:-G0|B0),Vars,X) :- !, revar((H0:-G0|B0),Vars,X).

revar('$VAR'(K),Vars,V) :- !, arg(K,Vars,V).
revar([],_,[]) :- !.
revar([H0|T0],Vars,[H|T]) :- !,
    revar(H0,Vars,H), revar(T0,Vars,T).
revar(X0,Vars,X) :-
    X0=..[F|L0], revar(L0,Vars,L), X=..[F|L].
