/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>

extern void *malloc();

static void initheap()
{
  declare_globals;
  unsigned long hsize;

  if(heapsize != 0  && incrementsize != 0) {
    hsize = (heapsize + incrementsize) * sizeof(q) * 2;
  } else {
    char buf[255];
    sprintf(buf,
	    "Illegal memory size specification: heap = %d, incremental = %d",
	    heapsize, incrementsize);
    fatal(buf);
  }
  if(!(heaptop = (q *)malloc(hsize))) fatal("Memory shortage\n");
  heapp = heaptop;
  heaplimit = real_heaplimit = heapp + heapsize;
  heapbottom = real_heaplimit+incrementsize;
  totalheapsize = hsize;
  halfheapsize = hsize / 2;
}

void initalloc()
{
  initheap();
}
