/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/bb.h>

#ifdef TRACE
extern int trace_flag;
extern int spontaneous_susp;
#endif

#define builtin_body_3(macro_body, pred, name)		\
     q x, y;						\
     q *allocp;						\
{							\
  extern struct predicate pred;				\
  q z;							\
 deref_x:						\
  if (isint(x)) {					\
  x_ok:							\
  deref_y:						\
    if (isint(y)) {					\
    ok:							\
      macro_body(x, y, z);				\
      return z;						\
    } else if (isref(y)) {				\
      q yy;						\
      yy = derefone(y);					\
      if (isint(yy)) {					\
	y = yy;						\
	goto ok;					\
      } else if (isref(yy)) {				\
	if (yy == y) {					\
	  goto suspend_y;				\
	} else {					\
	  q yyy = derefone(yy);				\
	  if (yyy == y) {				\
	    goto suspend_y;				\
	  } else {					\
	    y = yy;					\
	    goto deref_y;				\
	  }						\
	}						\
      }							\
    }							\
  } else if (isref(x)) {				\
    q xx;						\
    xx = derefone(x);					\
    if (isint(xx)) {					\
      x = xx;						\
      goto x_ok;					\
    } else if (isref(xx)) {				\
      if (xx == x) {					\
	goto suspend_x;					\
      } else {						\
	q xxx = derefone(xx);				\
	if (xxx == x) {					\
	  goto suspend_x;				\
	} else {					\
	  x = xx;					\
	  goto deref_x;					\
	}						\
      }							\
    }							\
  }							\
  builtin_3_type_error(x, y, &pred, name);		\
 suspend_x:						\
  return suspend_builtin_3(x, x, y, &pred, allocp);	\
 suspend_y:						\
  return suspend_builtin_3(y, x, y, &pred, allocp);	\
}

#define builtin_body_2(macro_body, pred, name)		\
     q x;						\
     q *allocp;						\
{							\
  extern struct predicate pred;				\
  q z;							\
 deref_x:						\
  if (isint(x)) {					\
  ok:							\
    macro_body(x, z);					\
    return z;						\
  } else if (isref(x)) {				\
    q xx;						\
    xx = derefone(x);					\
    if (isint(xx)) {					\
      x = xx;						\
      goto ok;						\
    } else if (isref(xx)) {				\
      if (xx == x) {					\
	goto suspend_x;					\
      } else {						\
	q xxx = derefone(xx);				\
	if (xxx == x) {					\
	  goto suspend_x;				\
	} else {					\
	  x = xx;					\
	  goto deref_x;					\
	}						\
      }							\
    }							\
  }							\
  builtin_2_type_error(x, &pred, name);			\
 suspend_x:						\
  return suspend_builtin_2(x, &pred, allocp);		\
}

static q suspend_builtin_3(v, x, y, pred, allocp)
     q v, x, y;
     Const struct predicate *pred;
     q *allocp;
{
  struct global_variables *glbl = &globals;
  struct goalrec *goal;
  q z;
  heapalloc(goal, 3+2, (struct goalrec *));
  z = makeref(&goal->args[2]);
  goal->pred = pred;
  goal->args[0] = x;
  goal->args[1] = y;
  goal->args[2] = z;
#ifdef TRACE
  spontaneous_susp = 1;
#endif
  suspend_goal(allocp, goal, v);
  return z;
}

static q suspend_builtin_2(v, pred, allocp)
     q v;
     Const struct predicate *pred;
     q *allocp;
{
  struct global_variables *glbl = &globals;
  struct goalrec *goal = 0;
  q z;
  heapalloc(goal, 2+2, (struct goalrec *));
  z = makeref(&goal->args[2]);
  goal->pred = pred;
  goal->args[0] = v;
  goal->args[1] = z;
#ifdef TRACE
  spontaneous_susp = 1;
#endif
  suspend_goal(allocp, goal, v);
  return z;
}

Volatile static builtin_3_type_error(x, y, pred, name)
     q x, y;
     struct predicate *pred;
     char *name;
{
  char buf[256];
  (void)sprintf(buf, "Argument type error in builtin predicate: %s\n", name);
  fatal(buf);
}

Volatile static builtin_2_type_error(x, pred, name)
     q x;
     struct predicate *pred;
     char *name;
{
  char buf[256];
  (void)strcpy(buf, "Argument type error in builtin predicate: ");
  (void)strcat(buf, name);
  (void)strcat(buf, "\n");
  fatal(buf);
}

q bblt_add_3(allocp, x, y)
builtin_body_3(bblt_add_no_check, predicate_integer__arithmetics_xadd_3,
	       "add/3")

q bblt_sub_3(allocp, x, y)
builtin_body_3(bblt_sub_no_check, predicate_integer__arithmetics_xsubtract_3,
	       "subtract/3")

q bblt_mult_3(allocp, x, y)
builtin_body_3(bblt_mult_no_check, predicate_integer__arithmetics_xmultiply_3,
	       "multiply/3")

q bblt_div_3(allocp, x, y)
builtin_body_3(bblt_div_no_check, predicate_integer__arithmetics_xdivide_3,
	       "divide/3")

q bblt_mod_3(allocp, x, y)
builtin_body_3(bblt_mod_no_check, predicate_integer__arithmetics_xmodulo_3,
	       "modulo/3")

q bblt_and_3(allocp, x, y)
builtin_body_3(bblt_and_no_check, predicate_integer__arithmetics_xand_3,
	       "and/3")

q bblt_or_3(allocp, x, y)
builtin_body_3(bblt_or_no_check, predicate_integer__arithmetics_xor_3,
	       "or/3")

q bblt_exclusive_or_3(allocp, x, y)
builtin_body_3(bblt_exclusive_or_no_check,
	       predicate_integer__arithmetics_xexclusive__or_3,
	       "exlclusive_or/3")

q bblt_rshift_3(allocp, x, y)
builtin_body_3(bblt_rshift_no_check,
	       predicate_integer__arithmetics_xshift__right_3,
	       "shift_right/3")

q bblt_lshift_3(allocp, x, y)
builtin_body_3(bblt_lshift_no_check,
	       predicate_integer__arithmetics_xshift__left_3,
	       "shift_left/3")

q bblt_plus_2(allocp, x)
builtin_body_2(bblt_plus_no_check,
	       predicate_integer__arithmetics_xplus_2,
	       "plus/2")

q bblt_minus_2(allocp, x)
builtin_body_2(bblt_minus_no_check,
	       predicate_integer__arithmetics_xminus_2,
	       "minus/2")

q bblt_complement_2(allocp, x)
builtin_body_2(bblt_complement_no_check,
	       predicate_integer__arithmetics_xcomplement_2,
	       "complement/2")
