/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

/*
  predicate

  method table
  ref to module
  predicate desc (atom)
*/


#include <nlist.h>
#include <stdio.h>
#include <klic/gdobject.h>
#include "atom.h"
#include "funct.h"

#define GD_CLASS_NAME() predicate
#define GD_OBJ_TYPE struct predicate_object
#define GD_OBJ_SIZE(obj) G_SIZE_IN_Q(GD_OBJ_TYPE)

#include <klic/gd_macro.h>

#include <klic/gmodule.h>

struct predicate_object {
  struct data_object_method_table *method_table;
  struct predicate *pdesc; /* atom tag */
  q module_obj;
  q predicate_name;
};

extern struct data_object_method_table *GD_method_table0(vector);

GDDEF_GUNIFY()
{
  G_STD_DECL;

  if(GD_SELF->method_table != GD_OTHER->method_table ||
     GD_SELF->pdesc != GD_OTHER->pdesc)
    GD_GFAIL;
  else 
    GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;

  if(GD_SELF->method_table != GD_OTHER->method_table ||
     GD_SELF->pdesc != GD_OTHER->pdesc)
    GD_UNIFY_FAIL;
  else
    GD_RETURN;
}

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->pdesc = GD_SELF->pdesc;
  GD_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->module_obj,newself->module_obj);
  newself->predicate_name = GD_SELF->predicate_name;
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(module_1)
{
  G_STD_DECL;

  GD_UNIFY(GD_ARGV[0],GD_SELF->module_obj);
  GD_RETURN;
}

GDDEF_METHOD(name_1)
{
  G_STD_DECL;

  GD_UNIFY(GD_ARGV[0],GD_SELF->predicate_name);
  GD_RETURN;
}

GDDEF_METHOD(arity_1)
{
  G_STD_DECL;
  struct predicate *pred =GD_SELF->pdesc;

  GD_UNIFY(GD_ARGV[0], makeint(pred->arity));
  GD_RETURN;
}

#define GD_ALLOC_GOAL(goal, pdesc, arity) \
{ \
  G_HEAPALLOC(goal,(size)+2,(struct goalrec *)); \
  (goal)->pred = (pdesc); \
}

#define GD_GOAL_ARG(i, goal) ((goal)->args[i])

#define G_ARITY_OF(fn) arityof(fn)

GDDEF_METHOD(apply_1)
{
  G_STD_DECL;
  
  q func;
  int size;

  GD_DEREF(GD_ARGV[0]);
  if (!(GD_IS_CLASS(vector,GD_ARGV[0]))) {
    GD_ERROR_IN_METHOD("Illegal second argument", "apply");
  }
  func = GD_ARGV[0];

  {
    struct goalrec *goal;
    q argv[2];
    int i;

    GD_CALL_GMETHOD(func,vector_1,argv);
    size = G_INTVAL(argv[0]);
    GD_ALLOC_GOAL(goal, GD_SELF->pdesc, size);
    for(i=0; i<size; ++i){
      argv[0] = G_MAKEINT(i);
      GD_CALL_GMETHOD(func,element_2,argv);
      GD_GOAL_ARG(i, goal) = argv[1];
    }
    G_PUSH_GOAL(goal);
  }
  GD_RETURN;
}

#define GD_METHOD_ARITY arities[g_method_functor - FUNCTORNUMBERBASE]

/* GDDEF_METHOD_NO_ARITY(call) */
GDDEF_METHOD(call)
{
  G_STD_DECL;
  
  int size = GD_METHOD_ARITY;

  {
    struct goalrec *goal;
    int i;

    GD_ALLOC_GOAL(goal, GD_SELF->pdesc, size);
    for(i=0; i<size; ++i){
      GD_GOAL_ARG(i, goal) = GD_ARGV[i];
    }
    G_PUSH_GOAL(goal);
  }
  GD_RETURN;
}

GDDEF_GENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_GMETHOD {
    GD_METHOD_CASE(module_1);
    GD_METHOD_CASE(name_1);
    GD_METHOD_CASE(arity_1);
    GD_METHOD_CASE(apply_1);
  default:
    GD_SWITCH_ON_GMETHOD_NAME {
      GD_METHOD_NAME_CASE(call);
      GD_METHOD_NAME_CASE_DEFAULT;
    }
  }
  GD_RETURN;
}

GDDEF_PRINT()
{
  G_STD_DECL;
  GD_PRINT("<PRED#");
  GD_PRINT_KL1_TERMS(GD_SELF->predicate_name, 0, 1);
  GD_PRINT(">");
  GD_RETURN_FROM_PRINT;
}

#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

GDDEF_GMETHOD(arity_1)
{
  G_STD_DECL;
  struct predicate *pred =GD_SELF->pdesc;

  GD_ARGV[0] =  makeint(pred->arity);
  GD_GSUCCEED;
}

GDDEF_GMETHOD(code_0)
{
  G_STD_DECL;
  if (GD_SELF->pdesc) {  GD_GSUCCEED; }
  else { GD_GFAIL; }
}

GDDEF_GGENERIC()
{
  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(code_0);
    GD_GMETHOD_CASE(arity_1);
    GD_GMETHOD_CASE_DEFAULT;
  }
}


#include <klic/gd_method_table.h>

/*
  new predicate
*/

GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  struct module_object *module_obj;
  q moduleName;
  q predname;
  int arity;
  char namebuf[256];
  char tmpbuf[256];
  struct nlist nl[2];
  char *prog_file_name;

  extern struct data_object_method_table GD_method_table1(module);
  extern char *get_program_file_name();

  if (GD_ARGC!=3) GD_ERROR_IN_NEW("Too few or too many arguments");
  GD_DEREF_FOR_NEW(GD_ARGV[0]);
  if(!G_ISFUNCTOR(GD_ARGV[0]) ||
     (((struct module_object *)(G_FUNCTORP(GD_ARGV[0])))->method_table
      != &(GD_method_table1(module)))) {
    GD_ERROR_IN_NEW("First parameter is not a module");
  }
  module_obj = (struct module_object *)(G_FUNCTORP(GD_ARGV[0]));

  GDSET_SYMARG_FOR_NEW(predname, GD_ARGV[1]);
  GDSET_INTARG_FOR_NEW(arity, GD_ARGV[2]);

#ifdef SYSV
  strcpy(namebuf, "predicate_");
#else
  strcpy(namebuf, "_predicate_");
#endif

  /*
    dirty work
    */
  moduleName = module_obj->name;
  strcat(namebuf, klic_encode(namestringof(moduleName), tmpbuf));

  strcat(namebuf, "_x");
  strcat(namebuf, klic_encode(namestringof(predname), tmpbuf));
  {
    char buf[20];

    sprintf(buf, "_%d", arity);
    strcat(namebuf, buf);
  }

  nl[0].n_name = namebuf;
  nl[1].n_name = (char *)0;
  if((nlist(prog_file_name = get_program_file_name(), nl) != 0) ||
     !ISVALIDSYMBOL(nl[0])) {
    nl[0].n_value = 0;
    /*
      char message[1024];
      sprintf(message,
      "Nonexistent predicate %s:%s/%d",
      namestringof(moduleName),
      namestringof(predname),
      arity);
      GD_ERROR_IN_NEW(message);
      */
  }
  free(prog_file_name);

  {
    GD_OBJ_TYPE *newpred;
    
    GDSET_NEWOBJ_FOR_NEW(newpred, sizeof(struct predicate_object));
    newpred->pdesc = (struct predicate *)(nl[0].n_value);
    newpred->module_obj = G_MAKEFUNCTOR(module_obj);
    newpred->predicate_name = predname;
    GD_RETURN_FROM_NEW(newpred);
  }
}
