/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

#include <math.h>
#include <stdio.h>
#include <klic/gdobject.h>
#include "atom.h"
#include "funct.h"

#define GD_CLASS_NAME() float
#define GD_OBJ_TYPE struct float_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

struct two_longs {
  long value1, value2;
};

GD_OBJ_TYPE {
  struct data_object_method_table *method_table;
  struct two_longs value;
};

union converter {
  struct two_longs lval;
  double dval;
} conv;

#define LTOD(v) (conv.lval=v, conv.dval)
#define DTOL(v) (conv.dval=v, conv.lval)

#include <klic/gd_macro.h>

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;
  if (GD_SELF->method_table != GD_OTHER->method_table ||
      GD_SELF->value.value1 != GD_OTHER->value.value1 ||
      GD_SELF->value.value2 != GD_OTHER->value.value2)
    GD_GUNIFY_FAIL;
  GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table ||
      GD_SELF->value.value1 != GD_OTHER->value.value1 ||
      GD_SELF->value.value2 != GD_OTHER->value.value2)
    GD_UNIFY_FAIL;
  GD_RETURN;
}

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->value = GD_SELF->value;
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;
  double self, result;
  unsigned long result_index;
  GD_OBJ_TYPE *newobj;

  GDSET_NEWOBJ(newobj);
  self = LTOD(GD_SELF->value);
  GD_SWITCH_ON_ARITY {
  case 1: {
    double (*func)();
    result_index = 0;
    GD_SWITCH_ON_METHOD {
    GD_METHOD_CASE_DIRECT(sin_1):
      func = sin; break;
    GD_METHOD_CASE_DIRECT(cos_1):
      func = cos; break;
    GD_METHOD_CASE_DIRECT(tan_1):
      func = tan; break;
    GD_METHOD_CASE_DIRECT(asin_1):
      func = asin; break;
    GD_METHOD_CASE_DIRECT(acos_1):
      func = acos; break;
    GD_METHOD_CASE_DIRECT(atan_1):
      func = atan; break;
    GD_METHOD_CASE_DIRECT(sinh_1):
      func = sinh; break;
    GD_METHOD_CASE_DIRECT(cosh_1):
      func = cosh; break;
    GD_METHOD_CASE_DIRECT(tanh_1):
      func = tanh; break;
    GD_METHOD_CASE_DIRECT(asinh_1):
      func = asinh; break;
    GD_METHOD_CASE_DIRECT(acosh_1):
      func = acosh; break;
    GD_METHOD_CASE_DIRECT(atanh_1):
      func = atanh; break;
    GD_METHOD_CASE_DIRECT(exp_1):
      func = exp; break;
    GD_METHOD_CASE_DIRECT(log_1):
      func = log; break;
    GD_METHOD_CASE_DIRECT(sqrt_1):
      func = sqrt; break;
    GD_METHOD_CASE_DIRECT(cbrt_1):
      func = cbrt; break;
    GD_METHOD_CASE_DIRECT(ceil_1):
      func = ceil; break;
    GD_METHOD_CASE_DIRECT(floor_1):
      func = floor; break;
    GD_METHOD_CASE_DIRECT(round_1):
      func = rint; break;
      GD_METHOD_CASE_DEFAULT;
    }
    result = func(self);
    break;
  }
  case 2: {
    q another = GD_ARGV[0];
    double another_value;
    GD_DEREF(another);
    result_index = 1;
    if (!isfunctor(another) ||
	((GD_OBJ_TYPE*)functorp(another))->method_table !=
	GD_SELF->method_table) {
      GD_FAIL("Illegal argument in floating point object method.");
    }
    another_value = LTOD(((GD_OBJ_TYPE *)functorp(another))->value);
    GD_SWITCH_ON_METHOD {
    GD_METHOD_CASE_DIRECT(add_2):
      result = self + another_value;
      break;
    GD_METHOD_CASE_DIRECT(subtract_2):
      result = self - another_value;
      break;
    GD_METHOD_CASE_DIRECT(multiply_2):
      result = self * another_value;
      break;
    GD_METHOD_CASE_DIRECT(divide_2):
      result = self / another_value;
      break;
    GD_METHOD_CASE_DIRECT(pow_2):
      result = pow(self, another_value);
      break;
      GD_METHOD_CASE_DEFAULT;
    }
    break;
  }
    GD_METHOD_CASE_DEFAULT;
  }
  newobj->value = DTOL(result);
  GD_UNIFY(GD_ARGV[result_index], makefunctor(newobj));
  GD_RETURN;
}

/* guard generic methods */

GDDEF_GMETHOD(less__than_1)
{
  G_STD_DECL;
  q otherq = GD_ARGV[0];
  GD_OBJ_TYPE *other;
  double self, another;

  if (!G_ISGOBJ(otherq)) GD_GFAIL;
  other = (GD_OBJ_TYPE *)G_FUNCTORP(otherq);
  if (other->method_table != GD_SELF->method_table) GD_GFAIL;
  self = LTOD(GD_SELF->value);
  another = LTOD(other->value);
  if (self < another) GD_GSUCCEED;
  GD_GFAIL;
}

GDDEF_GMETHOD(float_0)
{
  G_STD_DECL;
  GD_GSUCCEED;
}

GDDEF_GGENERIC()
{
  G_STD_DECL;
  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(less__than_1);
    GD_GMETHOD_CASE(float_0);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  fprintf(g_fp, "%f", LTOD(GD_SELF->value));
  GD_RETURN_FROM_PRINT;
}

#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

/* define the method table structure of the vector */

#include <klic/gd_method_table.h>

/*  new_float function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  long init;
  GD_OBJ_TYPE *newobj;

  GDSET_INTARG_FOR_NEW(init,GD_ARGV[0]);
  GDSET_NEWOBJ_FOR_NEW(newobj,G_SIZE_IN_Q(GD_OBJ_TYPE));
  newobj->value = DTOL((double)init);
  GD_RETURN_FROM_NEW(newobj);
}
