/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

/*
  Vector Objects
*/

#include <stdio.h>
#include <klic/gdobject.h>
#include "atom.h"
#include "funct.h"

struct vector_object {
  struct data_object_method_table *method_table;
  q next;
  long index:(8*sizeof(long)-1); /* size or index */
  int iscnst:1;
  union {
    q *body;
    q data;
  } u;
};

#define GD_CLASS_NAME()		vector
#define GD_OBJ_TYPE		struct vector_object
#define GD_OBJ_SIZE(obj)	(G_SIZE_IN_Q(GD_OBJ_TYPE))

#include <klic/gd_macro.h>

#define VECTOR_OBJ(x)	((GD_OBJ_TYPE *)(G_FUNCTORP(x)))

/* shallowing */

#define SHALLOW_MARK		(G_MAKEINT(0))
#define IS_SHALLOW(vector)	((vector)->next == SHALLOW_MARK)

static do_shallow(vector)
     struct vector_object *vector;
{
  q v, last, next;

  /* Go down to the shallwed version inverting pointers */
  last = SHALLOW_MARK;
  v = GD_OBJ(vector);
  do {
    next = VECTOR_OBJ(v)->next;
    VECTOR_OBJ(v)->next = last;
    last = v;
    v = next;
  } while (v != SHALLOW_MARK);
  v = last;

  /* Update physical vector elements tracing the inverted pointers */
  {
    long size = VECTOR_OBJ(v)->index;
    q *body = VECTOR_OBJ(v)->u.body;
    next = VECTOR_OBJ(v)->next;
    do {
      long index;
      index = VECTOR_OBJ(next)->index;
      VECTOR_OBJ(v)->index = index;
      VECTOR_OBJ(v)->u.data = body[index];
      body[index] = VECTOR_OBJ(next)->u.data;
      v = next;
      next = VECTOR_OBJ(v)->next;
    } while (next != SHALLOW_MARK);
    VECTOR_OBJ(v)->index = size;
    VECTOR_OBJ(v)->u.body = body;
  }
}

#define Shallow(vector) \
{ if (!IS_SHALLOW(vector)) do_shallow(vector); }

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;
  long size, k;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_GUNIFY_FAIL;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  Shallow(GD_OTHER);
  if (GD_OTHER->index != size) GD_GUNIFY_FAIL;
  for (k=0; k<size; k++) {
    q retval;
    q x = GD_OTHER->u.body[k];
    Shallow(GD_SELF);
    retval = GD_GUNIFY(GD_SELF->u.body[k], x);
    switch ((long)retval) {
    case GD_GSUCCESS:
      break;
    case GD_GFAILURE:
      GD_GUNIFY_FAIL;
      break;
    default:
      GD_GRETURN(retval);
    }
    Shallow(GD_OTHER);
  }
  GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;
  long size, k;

  if (GD_SELF->method_table != GD_OTHER->method_table) GD_UNIFY_FAIL;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  Shallow(GD_OTHER);
  if (GD_OTHER->index != size) GD_UNIFY_FAIL;
  for (k=0; k<size; k++) {
    q x = GD_OTHER->u.body[k];
    Shallow(GD_SELF);
    GD_UNIFY(GD_SELF->u.body[k], x);
    Shallow(GD_OTHER);
  }
  GD_RETURN;
}

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  if (IS_SHALLOW(GD_SELF)) {
    /* Shallow version */
    q *body = GD_SELF->u.body;
    long size = GD_SELF->index;
    q *newbody;
    long k;
    if ((g_allocp+size)>real_heaplimit) fatal("not enough space collected");
    newbody = g_allocp;
    g_allocp += size;
    newself->next = SHALLOW_MARK;
    newself->index = size;
    newself->iscnst = GD_SELF->iscnst;
    newself->u.body = newbody;
    for (k=0; k<size; k++) {
      q elem = body[k];
      if (G_ISREF(elem)) {
	q *newelem = g_allocp;
	g_allocp++;
	newbody[k] = (q)newelem;
	GD_COPY_KL1_TERM_TO_NEWGEN(*(q*)elem, *(q*)newelem);
      } else {
	GD_COPY_KL1_TERM_TO_NEWGEN(body[k], newbody[k]);
      }
    }
  } else {
    /* Deep version */
    newself->index = GD_SELF->index;
    newself->iscnst = 0;
    GD_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->next, newself->next);
    GD_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->u.data, newself->u.data);
  }
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(element_2)
{
  G_STD_DECL;
  int position;
  Shallow(GD_SELF);
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->index);
  GD_UNIFY(GD_ARGV[1], GD_SELF->u.body[position]);
  GD_RETURN;
}

GDDEF_METHOD(set__element_3)
{
  G_STD_DECL;
  long position;
  long size;
  GD_OBJ_TYPE *newvect;
  q *body;
  int iscnst;

  Shallow(GD_SELF);
  size = GD_SELF->index;
  iscnst = GD_SELF->iscnst;
  body = GD_SELF->u.body;
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,size);
  GDSET_NEWOBJ(newvect);
  if (!iscnst) {
    q olddata = body[position];

    GD_SELF->index = position;
    GD_SELF->u.data = olddata;
    body[position] = GD_ARGV[1];
    GD_SELF->next = GD_OBJ(newvect);
    newvect->u.body = body;
  } else {
    long k;
    q *newbody;
    GD_ALLOC_AREA(newbody,(q*),size);
    for (k=0; k<size; k++) newbody[k] = body[k];
    newbody[position] = GD_ARGV[1];
    newvect->u.body = newbody;
  }
  newvect->next = SHALLOW_MARK;
  newvect->index = size;
  newvect->iscnst = iscnst;
  GD_UNIFY_VALUE(GD_ARGV[2], GD_OBJ(newvect));
  GD_RETURN;
}

GDDEF_METHOD(set__element_4)
{
  G_STD_DECL;
  long position;
  long size;
  GD_OBJ_TYPE *newvect;
  q *body;
  int iscnst;
  q olddata;

  Shallow(GD_SELF);
  size = GD_SELF->index;
  body = GD_SELF->u.body;
  iscnst = GD_SELF->iscnst;

  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,size);
  GDSET_NEWOBJ(newvect);
  olddata = body[position];
  GD_UNIFY(GD_ARGV[1], olddata);
  if (!iscnst) {
    GD_SELF->index = position;
    GD_SELF->u.data = olddata;
    body[position] = GD_ARGV[2];
    GD_SELF->next = GD_OBJ(newvect);
    newvect->u.body = body;
  } else {
    long k;
    q *newbody;
    GD_ALLOC_AREA(newbody,(q*),size);
    for (k=0; k<size; k++) newbody[k] = body[k];
    newbody[position] = GD_ARGV[2];
    newvect->u.body = newbody;
  }
  newvect->next = SHALLOW_MARK;
  newvect->index = size;
  newvect->iscnst = iscnst;
  GD_UNIFY_VALUE(GD_ARGV[3], GD_OBJ(newvect));
  GD_RETURN;
}


/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_METHOD{
    GD_METHOD_CASE(element_2);
    GD_METHOD_CASE(set__element_3);
    GD_METHOD_CASE(set__element_4);
    GD_METHOD_CASE_DEFAULT;
  }
  GD_RETURN;
}

/* guard generic methods */

GDDEF_GMETHOD(element_2)
{
  G_STD_DECL;
  long position;

  Shallow(GD_SELF);
  GDSET_GINTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->index);
  GD_ARGV[1] = GD_SELF->u.body[position];
  GD_GSUCCEED;
}

GDDEF_GMETHOD(vector_1)
{
  G_STD_DECL;
  Shallow(GD_SELF);
  GD_ARGV[0] = G_MAKEINT(GD_SELF->index);
  GD_GSUCCEED;
}

GDDEF_GGENERIC()
{
  G_STD_DECL;
  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(element_2);
    GD_GMETHOD_CASE(vector_1);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  long size, k;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  GD_PRINT("{");
  if (size != 0) GD_PRINT_KL1_TERM(GD_SELF->u.body[0]);
  for (k=1; k<size; k++) {
    GD_PRINT(",");
    if (size>0) GD_PRINT_KL1_TERM(GD_SELF->u.body[k]);
  }
  GD_PRINT("}");
  GD_RETURN_FROM_PRINT;
}

#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

/* define the method table structure of the vector */

#include <klic/gd_method_table.h>

/*  new_vector function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  GD_OBJ_TYPE *newvect;
  q *body;
  q result;
  long size, k;
  q init;

  if (GD_ARGC!=1) GD_ERROR_IN_NEW("Too few or too many arguments");
  init = GD_ARGV[0];
  GD_DEREF_FOR_NEW(init);
  GDSET_NEWOBJ_FOR_NEW(newvect, G_SIZE_IN_Q(GD_OBJ_TYPE));
  if (G_ISINT(init)) {
    size = G_INTVAL(init);
    if (size < 0) GD_ERROR_IN_NEW("Negative size specified");
    GD_ALLOC_AREA_FOR_NEW(body, (q*), size);
    for (k=0; k<size; k++) body[k] = G_MAKEINT(0L);
  } else if (init==NILATOM || G_ISCONS(init)) {
    for (size=0; ; size++) {
      if (init == NILATOM) break;
      init = G_CDR_OF(init);
      GD_DEREF_FOR_NEW(init);
      if (init!=NILATOM && !G_ISCONS(init))
	GD_ERROR_IN_NEW("Illegal parameter");
    }
    init = GD_ARGV[0];
    GD_ALLOC_AREA_FOR_NEW(body, (q*), size);
    for (k=0; k<size; k++) {
      GD_DEREF_FOR_NEW(init);
      body[k] = G_CAR_OF(init);
      init = G_CDR_OF(init);
    }
  } else {
    GD_ERROR_IN_NEW("Illegal parameter");
  }
  newvect->next = SHALLOW_MARK;
  newvect->iscnst = 0;
  newvect->index = size;
  newvect->u.body = body;
  GD_RETURN_FROM_NEW(newvect);
}

/* Interface with builtin predicates */

q size_of_vector(v)
     q v;
{
  Shallow(VECTOR_OBJ(v));
  return G_MAKEINT(VECTOR_OBJ(v)->index);
}

q element_of_vector(v, k)
     q v, k;
{
  Shallow(VECTOR_OBJ(v));
  if (G_INTVAL(k) < 0 || VECTOR_OBJ(v)->index <= G_INTVAL(k)) {
    return (q) 0;
  } else {
    return VECTOR_OBJ(v)->u.body[G_INTVAL(k)];
  }
}
