/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

#include <stdio.h>
#include <klic/gdobject.h>
#include <klic/g_string.h>
#include "atom.h"
#include "funct.h"

#ifdef SYSV
#include <string.h>
#define BCMP			memcmp
#define BCOPY(from,to,len)	memcpy(to,from,len)
#define BZERO(from,len)		memset(from,0,len)
#else
#define BCMP			bcmp
#define BCOPY(from,to,len)	bcopy(from,to,len)
#define BZERO(from,len)		bzero(from,len)
#endif

#define GD_CLASS_NAME() byte__string
#define GD_OBJ_TYPE struct byte_string_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))
#define ELEMSIZE 8

#include <klic/gd_macro.h>

#define STRING_OBJ(x)	((GD_OBJ_TYPE *)(G_FUNCTORP(x)))

/* shallowing */

#define SHALLOW_MARK		(G_MAKEINT(0))
#define IS_SHALLOW(string)	((string)->next == SHALLOW_MARK)

static do_shallow(string)
     struct byte_string_object *string;
{
  q s, last, next;

  /* Go down to the shallwed version inverting pointers */
  last = SHALLOW_MARK;
  s = GD_OBJ(string);
  do {
    next = STRING_OBJ(s)->next;
    STRING_OBJ(s)->next = last;
    last = s;
    s = next;
  } while (s != SHALLOW_MARK);
  s = last;

  /* Update physical string elements tracing the inverted pointers */
  {
    long size = STRING_OBJ(s)->index;
    unsigned char *body = STRING_OBJ(s)->u.body;
    next = STRING_OBJ(s)->next;
    do {
      long index;
      index = STRING_OBJ(next)->index;
      STRING_OBJ(s)->index = index;
      STRING_OBJ(s)->u.data = body[index];
      body[index] = STRING_OBJ(next)->u.data;
      s = next;
      next = STRING_OBJ(s)->next;
    } while (next != SHALLOW_MARK);
    STRING_OBJ(s)->index = size;
    STRING_OBJ(s)->u.body = body;
  }
}

#define Shallow(string) \
{ if (!IS_SHALLOW(string)) do_shallow(string); }

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;
  long size, k;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_GUNIFY_FAIL;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  Shallow(GD_OTHER);
  if (GD_OTHER->index != size) GD_GUNIFY_FAIL;
  if (IS_SHALLOW(GD_SELF)) {
    if (BCMP(GD_SELF->u.body, GD_OTHER->u.body, size) != 0) GD_GUNIFY_FAIL;
  } else {
    for (k=0; k<size; k++) {
      q retval;
      unsigned char c = GD_OTHER->u.body[k];
      Shallow(GD_SELF);
      if (GD_SELF->u.body[k] != c) GD_GUNIFY_FAIL;
      Shallow(GD_OTHER);
    }
  }
  GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;
  long size, k;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_UNIFY_FAIL;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  Shallow(GD_OTHER);
  if (GD_OTHER->index != size) GD_UNIFY_FAIL;
  if (IS_SHALLOW(GD_SELF)) {
    if (BCMP(GD_SELF->u.body, GD_OTHER->u.body, size) != 0) GD_UNIFY_FAIL;
  } else {
    for (k=0; k<size; k++) {
      q retval;
      unsigned char c = GD_OTHER->u.body[k];
      Shallow(GD_SELF);
      if (GD_SELF->u.body[k] != c) GD_UNIFY_FAIL;
      Shallow(GD_OTHER);
    }
  }
  GD_RETURN;
}

#define ROUND_UP(size)	(((size)+sizeof(q)-1)/sizeof(q))

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  if (IS_SHALLOW(GD_SELF)) {
    unsigned char *body = GD_SELF->u.body;
    unsigned char *newbody;
    long size = GD_SELF->index;
    long qsize = ROUND_UP(size);
    long k;
    if ((g_allocp+qsize)>real_heaplimit) fatal("not enough space collected");
    newbody = (unsigned char *)g_allocp;
    g_allocp += qsize;
    newself->next = SHALLOW_MARK;
    newself->index = size;
    newself->iscnst = GD_SELF->iscnst;
    newself->u.body = newbody;
    BCOPY(body,newbody,qsize*sizeof(q));
  } else {
    newself->iscnst = 0;
    newself->index = GD_SELF->index;
    newself->u.data = GD_SELF->u.data;
    GD_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->next, newself->next);
  }
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(string_2)
{
  G_STD_DECL;
  long position;
  Shallow(GD_SELF);
  GD_UNIFY( GD_ARGV[0],G_MAKEINT(GD_SELF->index));
  GD_UNIFY( GD_ARGV[1],G_MAKEINT(ELEMSIZE));
  GD_RETURN;
}

GDDEF_METHOD(element_2)
{
  G_STD_DECL;
  long position;
  Shallow(GD_SELF);
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->index);
  GD_UNIFY( GD_ARGV[1],G_MAKEINT((unsigned long)(GD_SELF->u.body[position])));
  GD_RETURN;
}

GDDEF_METHOD(set__element_3)
{
  G_STD_DECL;
  long position, newelem;
  GD_OBJ_TYPE *newstr;
  unsigned char *body;
  int iscnst;
  long size;

  Shallow(GD_SELF);
  size = GD_SELF->index;
  iscnst = GD_SELF->iscnst;
  body = GD_SELF->u.body;
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,size);
  GDSET_INTARG_WITHIN_RANGE(newelem,GD_ARGV[1],0,256);
  GDSET_NEWOBJ(newstr);
  if (!iscnst) {
    unsigned char olddata = body[position];

    GD_SELF->index = position;
    GD_SELF->u.data = olddata;
    body[position] = newelem;
    GD_SELF->next = GD_OBJ(newstr);
    newstr->u.body = body;
  } else {
    long k;
    unsigned char *newbody;
    long qsize = ROUND_UP(size);
    GD_ALLOC_AREA(newbody, (unsigned char *), qsize);
    BCOPY(body, newbody, qsize*sizeof(q));
    newbody[position] = newelem;
    newstr->u.body = newbody;
  }
  newstr->next = SHALLOW_MARK;
  newstr->index = size;
  newstr->iscnst = iscnst;
  GD_UNIFY_VALUE(GD_ARGV[2], GD_OBJ(newstr));
  GD_RETURN;
}

GDDEF_METHOD(search__character_4)
{
  G_STD_DECL;
  unsigned long start, end, code;
  unsigned long k;

  Shallow(GD_SELF);
  GDSET_INTARG_WITHIN_RANGE(start,GD_ARGV[0],0,GD_SELF->index);
  GDSET_INTARG_WITHIN_RANGE(end,GD_ARGV[1],0,GD_SELF->index);
  GDSET_INTARG_WITHIN_RANGE(code,GD_ARGV[2],0,256);
  if (start <= end) {
    for (k=start; k<=end; k++) {
      if (((unsigned long) GD_SELF->u.body[k]) == code) goto done;
    }
  } else {
    for (k=start; k>=end; k--) {
      if (((unsigned long) GD_SELF->u.body[k]) == code) goto done;
    }
  }
  GD_UNIFY(GD_ARGV[3],G_MAKEINT(-1L));
  GD_RETURN;

  done:
    GD_UNIFY(GD_ARGV[3],G_MAKEINT(k));
  GD_RETURN;
}


/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_METHOD{
    GD_METHOD_CASE(string_2);
    GD_METHOD_CASE(element_2);
    GD_METHOD_CASE(set__element_3);
    GD_METHOD_CASE(search__character_4);
    GD_METHOD_CASE_DEFAULT;
  }
  GD_RETURN;
}

/* guard generic methods */

GDDEF_GMETHOD(element_2)
{
  G_STD_DECL;
  unsigned long position;

  Shallow(GD_SELF);
  GDSET_GINTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->index);
  GD_ARGV[1] = G_MAKEINT((long)(GD_SELF->u.body[position]));
  GD_GSUCCEED;
}

GDDEF_GMETHOD(string_2)
{
  G_STD_DECL;
  unsigned long position;

  Shallow(GD_SELF);
  GD_ARGV[0] = G_MAKEINT(GD_SELF->index);
  GD_ARGV[1] = G_MAKEINT(ELEMSIZE);
  GD_GSUCCEED;
}

static int compare_two_strings(s1, s2)
     GD_OBJ_TYPE *s1, *s2;
{
  long size1, size2, minsize, k;
  Shallow(s1);
  size1 = s1->index;
  Shallow(s2);
  size2 = s2->index;
  minsize = ((size1 < size2) ? size1 : size2);
  if (!IS_SHALLOW(s1)) {
    /* s1 and s2 are different versions of the same string */
    for (k=0; k<minsize; k++) {
      unsigned char c;
      Shallow(s1);
      c = s1->u.body[k];
      Shallow(s2);
      if (c != s2->u.body[k]) {
	return ((c < s2->u.body[k]) ? -(k+1) : k+1);
      }
    }
  } else {
    for (k=0; k<minsize; k++) {
      if (s1->u.body[k] != s2->u.body[k]) {
	return ((s1->u.body[k] < s2->u.body[k]) ? -(k+1) : k+1);
      }
    }
  }
  if (size1 != size2) {
    return ((size1<size2) ? -(size1+1) : size2+1);
  } else {
    return 0;
  }
}

GDDEF_GMETHOD(less__than_1)
{
  G_STD_DECL;
  q otherq = GD_ARGV[0];
  GD_OBJ_TYPE *other;
  int cmp;

  if (!G_ISGOBJ(otherq)) GD_GFAIL;
  other = (GD_OBJ_TYPE *)G_FUNCTORP(otherq);
  if (other->method_table != GD_SELF->method_table) GD_GFAIL;
  cmp = compare_two_strings(GD_SELF, other);
  if (cmp < 0) GD_GSUCCEED; else GD_GFAIL;
}

GDDEF_GMETHOD(not__less__than_1)
{
  G_STD_DECL;
  q otherq = GD_ARGV[0];
  GD_OBJ_TYPE *other;
  int cmp;

  if (!G_ISGOBJ(otherq)) GD_GFAIL;
  other = (GD_OBJ_TYPE *)G_FUNCTORP(otherq);
  if (other->method_table != GD_SELF->method_table) GD_GFAIL;
  cmp = compare_two_strings(GD_SELF, other);
  if (cmp >= 0) GD_GSUCCEED; else GD_GFAIL;
}

GDDEF_GMETHOD(estring_3)
{
  G_STD_DECL;
  long size, k;
  q tmp;

  Shallow(GD_SELF);
  size = GD_SELF->index;
  if (G_INTVAL(GD_ARGV[0])!= size) GD_GFAIL;
  if (G_INTVAL(GD_ARGV[1])!= ELEMSIZE) GD_GFAIL;
  tmp = GD_ARGV[2];
  for(k=0; k<size; k++, tmp = G_CDR_OF(tmp)) {
    if(G_INTVAL(G_CAR_OF(tmp))!= GD_SELF->u.body[k]) GD_GFAIL;
  }
  GD_GSUCCEED;
}

GDDEF_GGENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(element_2);
    GD_GMETHOD_CASE(string_2);
    GD_GMETHOD_CASE(less__than_1);
    GD_GMETHOD_CASE(not__less__than_1);
    GD_GMETHOD_CASE(estring_3);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  long size;
  int i;
  Shallow(GD_SELF);
  size = GD_SELF->index;
  GD_PUTC('"');
  for (i = 0; i < size; i++) { GD_PUTC(GD_SELF->u.body[i]); }
  GD_PUTC('"');
  GD_RETURN_FROM_PRINT;
}

#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

/* define the method table structure of the vector */
#include <klic/gd_method_table.h>

/*  new_string function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  GD_OBJ_TYPE *newstr;
  unsigned char *body;
  long size;
  q result;
  q init;

  if (GD_ARGC!=1) GD_ERROR_IN_NEW("Too few or too many arguments");
  init = GD_ARGV[0];
  GD_DEREF_FOR_NEW(init);
  GDSET_NEWOBJ_FOR_NEW(newstr, G_SIZE_IN_Q(GD_OBJ_TYPE));
  if (G_ISINT(init)) {
    long qsize;
    size = G_INTVAL(init);
    if (size < 0) GD_ERROR_IN_NEW("Negative size specified");
    qsize = ROUND_UP(size);
    GD_ALLOC_AREA_FOR_NEW(body, (unsigned char *), qsize*sizeof(q));
    BZERO(body, qsize*sizeof(q));
  } else if (init==NILATOM || G_ISCONS(init)) {
    long qsize, k;
    for (size=0; ; size++) {
      q elem;
      if (init == NILATOM) break;
      elem = G_CAR_OF(init);
      GD_DEREF_FOR_NEW(elem);
      if (!G_ISINT(elem) || G_INTVAL(elem) < 0 || 256 <= G_INTVAL(elem)) {
	GD_ERROR_IN_NEW("Illegal parameter");
      }
      init = G_CDR_OF(init);
      GD_DEREF_FOR_NEW(init);
      if (init!=NILATOM && !G_ISCONS(init))
	GD_ERROR_IN_NEW("Illegal parameter");
    }
    qsize = ROUND_UP(size);
    init = GD_ARGV[0];
    GD_ALLOC_AREA_FOR_NEW(body, (unsigned char *), qsize*sizeof(q));
    for (k=0; k<size; k++) {
      q elem;
      GD_DEREF_FOR_NEW(init);
      elem = G_CAR_OF(init);
      GD_DEREF_FOR_NEW(elem);
      body[k] = G_INTVAL(elem);
      init = G_CDR_OF(init);
    }
  } else {
    GD_ERROR_IN_NEW("Illegal parameter");
  }
  newstr->next = SHALLOW_MARK;
  newstr->iscnst = 0;
  newstr->index = size;
  newstr->u.body = body;
  GD_RETURN_FROM_NEW(newstr);
}


unsigned char *generic_string_body(str)
GD_OBJ_TYPE *str;
{
  Shallow(str);
  return (str->u.body);
}

unsigned long generic_string_size(str)
GD_OBJ_TYPE *str;
{
  Shallow(str);
  return (str->index);
}

q gd_new_string(size,g_allocp)
     long size;
     q *g_allocp;
{
  q argv[1];
  argv[0] = makeint(size);
  return byte__string_g_new(1,argv,g_allocp);
}

q gd_list_to_string(list,g_allocp)
     q list;
     q *g_allocp;
{
  q argv[2];
  argv[0] = list;
  return byte__string_g_new(1,argv,g_allocp);
}

q convert_c_string_to_klic_string(cstr,g_allocp)
     char *cstr;
     q *g_allocp;
{
  q argv[1];
  q str;
  long len = strlen(cstr);
  argv[0] = makeint(len);
  str = byte__string_g_new(1,argv,g_allocp);
  BCOPY(cstr, ((struct byte_string_object *)functorp(str))->u.body, len);
  return str;
}

q convert_binary_c_string_to_klic_string(cstr,len,g_allocp)
     char *cstr;
     long len;
     q *g_allocp;
{
  q argv[1];
  q str;
  argv[0] = makeint(len);
  str = byte__string_g_new(1,argv,g_allocp);
  BCOPY(cstr, ((struct byte_string_object *)functorp(str))->u.body, len);
  return str;
}

char *convert_klic_string_to_c_string(s)
     q s;
{
  struct byte_string_object *str =
    (struct byte_string_object *)functorp(s);
  char *cstr;
  Shallow(str);
  cstr = (char *)malloc(str->index+1);
  strncpy(cstr, str->u.body, str->index);
  cstr[str->index] = '\0';
  return cstr;
}

/* Interface with builtin */

q size_of_string(s)
     q s;
{
  Shallow(STRING_OBJ(s));
  return G_MAKEINT(STRING_OBJ(s)->index);
}

q element_of_string(s, k)
     q s, k;
{
  Shallow(STRING_OBJ(s));
  if (G_INTVAL(k) < 0 || STRING_OBJ(s)->index <= G_INTVAL(k)) {
    return (q) 0;
  } else {
    return G_MAKEINT(STRING_OBJ(s)->u.body[G_INTVAL(k)]);
  }
}

#undef GD_CLASS_NAME
#define GD_CLASS_NAME() string

GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  long elemsize;

  if (GD_ARGC!=2) GD_ERROR_IN_NEW("Too few or too many arguments");
  GDSET_INTARG_FOR_NEW(elemsize, GD_ARGV[1]);
  if (elemsize != 8) GD_ERROR_IN_NEW("Only byte strings are supported now");
  return byte__string_g_new(1,GD_ARGV,g_allocp);
}
