;;;
;;;   KNOWBEL knowledge representation system
;;;    
;;;    author: Bryan M. Kramer
;;;    
;;;    
;;; Copyright (c) 1990, 1991 University of Toronto, Toronto, ON
;;;
;;; Permission is granted to any individual or institution to use, copy,
;;; modify, and distribute this software, provided that this complete
;;; copyright and permission notice is maintained, intact, in all copies and
;;; supporting documentation.
;;;
;;; The University of Toronto provides this software "as is" without
;;; express or implied warranty.
;;;

;;;    
;;;    


;? test functions --- NOTE some are obsolete


(defmacro test ()
  `(tell '
    (,(gensym "boiler")
     instance ((Token)  (Boiler))
     with 
     (
      (linked-from 
       (_ mv58)
       (_ mv183))
      (max-volume 
       (_ 100))
      (install-time
       (_ 1983))
      (level
       (_ 2.32 1990_5_7_11_40)
       )
      (pressure 
       (_ 11 1990_5_7_11_40))
      (temperature 
       (_ 450 1990_5_7_11_40))
      ) 
     ))
  )

(defmacro test2 ()
  `(tell '
    (,(gensym "Preheater-1")
     instance ((Token)  (Preheater))
     with (
	   (install-time
	    (_ 1984))
	   (pressure 
	    (_ 4 1990_5_7_11_40))
	   (temperature 
	    (_ 140 1990_5_7_11_40))
	   (name
	    (_ HX1))
	   (connected
	    (_ Prehtr-low-temperature-alarm-1)
	    (_ Prehtr-high-temperature-alarm-1)
	    (_ Prehtr-low-pressure-alarm-1)
	    (_ Prehtr-high-pressure-alarm-1))     
	   ) 
     ))
  )


(defmacro test3 ()
  `(tell '(,(gensym "Boiler-2")
   instance ((Token)  (Boiler))
   with (
     (max-volume 
           (_ 100))
     (install-time
           (_ 1985))
     (name
           (_ BO2))
     (level
           (_ 2.35 1990_5_7_11_40)
           )
     (pressure 
           (_ 11 1990_5_7_11_40))
     (temperature 
           (_ 450 1990_5_7_11_40))
     (connected
           (_ Boiler-max-high-level-alarm-2)
           (_ Boiler-very-high-level-alarm-2)
           (_ Boiler-high-level-alarm-2)
           (_ Boiler-min-low-level-alarm-2)
           (_ Boiler-very-low-level-alarm-2)
           (_ Boiler-low-level-alarm-2)
           (_ Boiler-high-temperature-alarm-2)
           (_ Boiler-low-temperature-alarm-2)
           (_ Boiler-high-pressure-alarm-2)
           (_ Boiler-low-pressure-alarm-2)
	   )

        ) 
       ))

  )



(defmacro test4 nil
  `(tell '(,(gensym "Boiler")
	   isa ((Feedwater-system-equipment))
	   instance ((S-Class))
	   with
	   (
	    ((necessary single)
	     (max-volume  Real)
	     )
	    (necessary  
	     (level Real)
	     (pressure Real)
	     (temperature Real)
	     (install-time  integer)
	     ) 
	    (attribute 
	     (connected Boiler-alarm)
	     (name string)
	     )  


	    (integrity-constraint
	     (boiler-level-constraint
	      (forall (|$boiler(boiler)| $l)
		      (=>
		       (member-of $l |$boiler(boiler)| level)

		       (and (>= $l 0) (< $l 2.5))
		       ))))
 
	    (deductive-rule
	     (_ (=>
		 (instance-of $boiler Boiler)
		 (member-of $l $boiler level)
		 (>= $l 2.31)
		 (member-of $b $boiler connected)
		 (instance-of $b Boiler-very-high-level-alarm)
		 (set-off $b state) 

		 (filter)
		 ))

	     (_ (=>
		 (instance-of $boiler Boiler)
		 (member-of $l $boiler level)
		 (>= $l 2.31)
		 (member-of $c $boiler connected)
		 (instance-of $c Boiler-high-level-alarm)
		 (set-off $c state)

		 (filter)
		 ))

	     (_ (=>
		 (instance-of $boiler Boiler)
		 (member-of $l $boiler level)
		 (>= $l 2.24)  
		 (< $l 2.31)
		 (member-of $c $boiler connected)
		 (instance-of $c Boiler-high-level-alarm)
		 (set-off $c state)

		 (filter)
		 ))

	     (_ (=>
		 (instance-of $boiler Boiler)
		 (member-of $l $boiler level)
		 (< $l 1.7)
		 (member-of $e $boiler connected)
		 (instance-of $e Boiler-very-low-level-alarm)
		 (set-off $e state)

		 (filter)
		 )) 

	     (_ (=>
		 (instance-of $boiler Boiler)
		 (member-of $l $boiler level)
		 (< $l 1.7)
		 (member-of $e $boiler connected)
		 (instance-of $e Boiler-low-level-alarm)
		 (set-off $e state)

		 (filter)
		 )) 

	     (_ (=>
		 (instance-of $boiler Boiler)
		 (member-of $l $boiler level)
		 (>= $l 1.7)
		 (< $l 1.8)
		 (member-of $f $boiler connected)
		 (instance-of $f Boiler-low-level-alarm)
		 (set-off $f state)

		 (filter)
		 )))


	    )
   
	   )
	 )
  )


(defmacro test-dr-query ()
  `(query1 '(not (attr aobj1 $l "a4" $r $p |$t(-,+)|)))
  )


(defmacro test-desc-query ()
  `(prog nil
     (query1 '(or (not (= $x #@(aclass (("a4" (_ 12345)))))) (not (attr $x $l "a4" $r $p |$t(-,+)|))))
     (query1 '(or (not (= $x #@(aclass (("a4" (_ 12345)))))) (not (instance-of $x aclass |$t(-,+)|))))
     (query1 '(or (not (= $x #@(aclass (("a4" (_ $r)))))) (not (attr aobj1 $l "a4" $r $p |$t(-,+)|))))
     )
  )


(defmacro test-dr (&key (init t) (do-query t))
  `(let ((h nil))
     (if ,init (setq th (init-kb)))
     (setq h (default-history))
     (dbgn-print 'def-single-class
		 (tell `(single-class
			 instance ((s-class))
			 with (
			       (single
				(x number))
			       ))
		       *theory* h))
     (dbgn-print 'inst-single-class *ic-checking*
		 (tell `(inst-sc
			 instance ((single-class))
			 with (
			       (x (x1 3) (x2 4))
			       ))
		       *theory* h))
     (dbgn-print 'class
		 (tell '(aclass
			 instance ((s-class))
			 with (
			       (attribute
				(a1 number :with (meta-rule (mr1 (=> (varp $v) (now $time)
								     (goal (attr $obj $l "a1" $v $p $h) $state (sigma (val $v $time)))))))
				(a2 number)
				(a3 number)
				(a4 number))
			       (integrity-constraint
				(small-a4 (=> (attr |$x(aclass)| $l1 "a4" $val $p1 |$t(-,+)|)
					      (< $val 10)))
				)
			       (deductive-rule
				(comp_a3 (=> (attr |$x(aclass)| $l1 "a1" $val1 $p1 |$t(-,+)|)
					     (attr |$x(aclass)| $l2 "a2" $val2 $p2 $t)
					     (+ $val1 $val2 $r)
					     (attr $x $l "a3" $r $p $t)))
				(comp_a4 (=> (attr |$x(aclass)| $l1 "a1" $val1 $p1 |$t(-,+)|)
					     (attr |$x(aclass)| $l2 "a3" $val2 $p2 $t)
					     (+ $val1 $val2 $r)
					     (attr $x $l "a4" $r $p $t)))
				))
			 )
		       *theory* h))
     (dbgn-print 'obj
		 (tell '(aobj1
			 instance ((aclass))
			 with (
			       (a1
				(_ 5))
			       (a2 (_ 6))))
		       *theory* h))
     (when ,do-query
       (dbgn-print 'query)
       (test-dr-query)
       )
     )
  )

(defmacro test-dl nil
  `(mlet ((class (gensym "ll")))
     (dbgn-print 'll
		 (tell `(,class
			 instance ((s-class))
			 with (
			       (single
				(x number))
			       (necessary (y number)))
			       )))
     (dbgn-print 'inst-ll
		 (tell `(,(gensym "inst-ll")
			 instance ((,class))
			 with (
			       (x (x1 3) (x2 4))
			       ))))
     (dbgn-print 'inst-ll
		 (tell `(,(gensym "inst2-ll")
			 instance ((,class))
			 )))
     )
  )

(defmacro test-sub nil
  `(mlet ((class (gensym "ll"))
	 (class2 (gensym "sub-ll")))
     (dbgn-print 'class
		 (tell `(,class
			 instance ((s-class))
			 with (
			       (single
				(x number))
			       (necessary (y number)))
			       )))
     (dbgn-print 'subclass
		 (tell `(,class2
			 instance ((s-class))
			 isa ((,class))
			 with (
			       (single
				(a number))
			       (necessary (y number)))
			       )))
     (dbgn-print 'inst-ll
		 (tell `(,(gensym "instx-ll")
			 instance ((,class2))
			 with ((x (_ 6))
			       (y (_ 5)))
			 )))
     (query1 `(not (attr ,class2 $lc $lcc $v $p |$t(-,+)|)))
     )
  )
     


(defmacro test-dr1 nil
  `(progn
     (dbgn-print 'class
		 (tell '(,(gensym "aclass")
			 instance ((s-class))
			 with (
			       (attribute
				(a1 number :with (meta-rule (mr1 (=> (varp $v) (now $time)
								     (goal (attr $obj $l "a1" $v $p $h) $state (sigma (val $v $time)))))))
				(a2 number)
				(a3 number)
				(a4 number))
			       (integrity-constraint
				(small-a4 (=> (attr |$x(aclass)| $l1 "a4" $val $p1 |$t(-,+)|)
					      (< $val 10)))
				)
			       (deductive-rule
				(comp_a3 (=> (attr |$x(aclass)| $l1 "a1" $val1 $p1 |$t(-,+)|)
					     (attr |$x(aclass)| $l2 "a2" $val2 $p2 $t)
					     (+ $val1 $val2 $r)
					     (attr $x $l "a3" $r $p $t)))
				(comp_a4 (=> (attr |$x(aclass)| $l1 "a1" $val1 $p1 |$t(-,+)|)
					     (attr |$x(aclass)| $l2 "a3" $val2 $p2 $t)
					     (+ $val1 $val2 $r)
					     (attr $x $l "a4" $r $p $t)))
				))
			 )))
     (dbgn-print 'obj
		 (tell '(,(gensym "aobj1")
			 instance ((aclass))
			 with (
			       (a1
				(_ 5))
			       (a2 (_ 6))))))
     (dbgn-print 'query)
     (test-dr-query)
     )
  )



(defmacro test-pre (&optional (init t))
  `(mlet ((class (gensym "pre-class"))
	 (inst (gensym "pre-inst")))
     (if ,init (setq th (init-kb)))
     (dbgn-print 'defining-class)
     (dbgn-print 'class
		 (tell `(,class
			 instance ((s-class))
			 with (
			       (precondition
				(x (number $y)))
			       ))))
     (kb-print-token (lookup-type class))
     (dbgn-print 'defining inst)
     (dbgn-print 'inst-ll
		 (tell `(,inst
			 instance ((,class))
			 with (
			       (x (x1 3) (x2 4))
			       ))))
     (when (lookup-type inst)
       (kb-print-token (lookup-type inst)))
     )
  )

;;; should be not compiled , resolve to nil only if cannot compile????

(defmacro test-compile (&optional (init t) (theory '*theory*))
  `(mlet ((theory ,theory)
	 (belief-alltime (make-belief-time :start :- :end :+)))
     (when ,init
       (ptrace nil)
       (setq th (init-kb))
       (setq theory th)
       (ptrace t))
     (telos-stash '(forall ($x |$class(class)| $label $label-class $v |$pclass(necessary)| |$t(-,+)|)
		    (or
		     (not (xxx-check $x $class $t))
		     (not (attr $x $label "necessary" $v $pclass $t))
		     (not (compiled
		      integrity-constraints
		      (bquote (or (not (instance-of $y (comma $x) (comma $t)))
				  (provable (exists |$p([necessary])|
						    (and (attr $y $xlabel $xlabel-class $xv $p (comma $t))
							 (instance-of $p (comma $pclass) (comma $t)))
						    ))))
		      $x))))
		  theory belief-alltime 'xxx-check (list :integrity-check-ignore t))
     (tell `(,(lookup-type "necessary" theory)
	     with ((integrity-constraint
		    (xxx-constraint (=> (instance-of |$x(class)| |$class(class)| |$t(-,+)|)
					(xxx-check $x $class $t)))))))
     (test-dl)
     )
  )



(defmacro test-time (&optional (init nil) (theory '*theory*))
  `(mlet ((theory ,theory)
	 (belief-alltime (make-belief-time :start :- :end :+)))
     (when ,init
       (ptrace nil)
       (test-dr nil)
       (ptrace t))

     (dbgn-print 'time-test
		 (tell `(inst-ll-time
			 instance ((single-class))
			 with (
			       (x (x1 3 (:after (instance-of inst-sc single-class))))
			       ))))
     )
  )


(defun test-lcv nil
  (query-collect '(or
		   (not (instance-of $x level-control-valve |$t(-,+)|))
		   (not (attr $x $l "open-position" $y $p $t))
		   (not (> $y 0))
		   )
		 :vars '($x))
  )


(defun test-filter-setup nil
  (progn
    (cnf-stash `(=>
		 (attr $o $l ,(lookup-string "corresponding-equipment" *theory*) $v $p |$t(-,+)|)
		 (connected $o $v)))
    )
  )


(defun test-filter-set-status nil
  (tell `(BLC-BO2-LT-24-M/R-LVL-IR with ((status (_ T 1990_5_7_11_01)))))
  (tell `(BLC-BO2-LT-21-N/R-LVL-IR with ((status (_ T 1990_5_7_11_01)))))
  )

(defun test-filter nil
  (query-collect '(or
		   (not (filter BLC-BO2-LT-24-M/R-LVL-IR))
		   )
		 :vars nil)
  )

(defun test-filter1 nil
  (query '(or
		   (not (filter BLC-BO2-LT-24-M/R-LVL-IR))
		   ))
  )


(defun test-fix-boiler nil
  (setq b (std-belief))
  (setq h (parse-time '(1989 +) (default-history) *theory* nil b nil))
  (tell '(Boiler
	  with
	  (
	   (deductive-rule
	    (bwlh (=>
		   (instance-of $a boiler-water-level-high)
		   (connected $boiler $a)
		   (connected $a1 $boiler)
		   (or (instance-of $a1 boiler-water-level-max-high)
		       (instance-of $a1 boiler-water-level-very-high))
		   (member-of t $a1 status)
		   (set-off $a status)

		   (filter $a)
		   ))

	    (bwlvh (=>
		    (instance-of $a boiler-water-level-very-high)
		    (connected $boiler $a)
		    (connected $a1 $boiler)
		    (instance-of $a1 boiler-water-level-max-high)
		    (member-of t $a1 status)
		    (set-off $a status)

		    (filter $a)
		    ))
	    (bwlocvh (=>
		      (instance-of $a boiler-water-level-one-chennel-very-high)
		      (connected $boiler $a)
		      (connected $a1 $boiler)
		      (or (instance-of $a1 boiler-water-level-very-high)
			  (instance-of $a1 boiler-water-level-max-high))
		      (member-of t $a1 status)
		      (set-off $a status)

		      (filter $a)
		      ))

	    (blla (=>
		   (instance-of $a boiler-low-level-alarm)
		   (connected $boiler $a)
		   (connected $a1 $boiler)
		   (or (instance-of $a1 boiler-min-low-level-alarm)
		       (instance-of $a1 boiler-very-low-level-alarm))
		   (member-of t $a1 status)
		   (set-off $a status)

		   (filter $a)
		   ))

	    (bvlla (=>
		    (instance-of $a boiler-very-low-level-alarm)
		    (connected $boiler $a)
		    (connected $a1 $boiler)
		    (instance-of $a1 boiler-min-low-level-alarm)
		    (member-of t $a1 status)
		    (set-off $a status)

		    (filter $a)
		    ))

	    (phpa (=>
		   (instance-of $a1 prehtr-high-pressure-alarm)
		   (connected $p $a1)
		   (instance-of $a2 flow-high-alarm)
		   (member-of t $a2 status)
		   (member-of t $a2 status (ago 300))
		   (set-off $a1 status)

		   (filter $a1)
		   ))
	    )


	   )
	  )
	*theory* h b)
  )


(defmacro load-alarm-kb (&optional name)
  `(loadkb ,(if name name "~wang/knowbel/alarm.cl") t nil '(- +))
  )


(defun test-flight (from to)
  (query1 `(or
	    (not (= $x #@((proto-flight-path)
			     (("from" (_ ,(lookup-type from) |$t(-,+)|))
			      ("to"(_  ,(lookup-type to) $t))
			      ("flight" (_ $flight $t))
			      ("subpath" (_ $p $t))))))
	    (not (instance-of $x flight-path $t))))
  )


(defun ask-flight (from to &optional (vars :all) (search :best))
  (prog1
      t
    (setq ask-state (#-:ccl ask #+:ccl telos-ask  `(and
						    (= $x #@((proto-flight-path)
							     (("from" (_ ,(lookup-type from) |$t(-,+)|))
							      ("to"(_  ,(lookup-type to) $t))
							      ("flight" (_ $flight $t))
							      ("cost" (_ $cost $t))
							      ("subpath" (_ $p $t)))))
						    (instance-of $x flight-path $t))
			    :vars vars
			    :search search)
	  ))
  )


(defun ask-flight1 (from to &optional (vars :all) (search :best))
  (prog1
      t
    (setq ask-state (#-:ccl ask #+:ccl telos-ask   `(and
			    (= $x #@(((proto-flight-path |$t(-,+)|))
				     (("from" (_ ,(lookup-type from) $t))
				      ("to"(_  ,(lookup-type to) $t))
				      ("flight" (_ $flight $t))
				      ("cost" (_ $cost $t))
				      ("subpath" (_ $p $t)))))
			    (instance-of $x flight-path $t))
			  :vars vars
			  :search search)
	  ))
  )

(defun ask-flight-again nil
  (prog1 t
    (setq ask-state (#-:ccl ask #+:ccl telos-ask  ask-state))
    )
  )


(defun flight-profile (n)
  (doloop :iter (i 0 (+ 1 i)) :while (< i n)
    (ask-flight 'toronto 'chengdu '($x))
    (ask-flight-again)
    )
  )


(defun filter-profile (n)
  (doloop :iter (i 0 (+ 1 i)) :while (< i n)
    (test-filter)
    )
  )


(defmacro test-airplane nil
  `(progn
     (setq b (std-belief))
     (tell '(,(gensym)
	     instance ((Token)  (Airplane))
	     with (
		   (name 
		    (_ DC-9))
		   (manufacturer 
		    (_ McDonald-Douglas))
		   (max-capacity 
		    (_ 124))
		   ))
	   *theory*
	   (parse-time '(1989 +) (default-history) *theory* nil b)
	   b)
     )
  )


(defmacro test-a-flight nil
  `(progn
     (setq b (std-belief))
     (ptrace t)
     (setq *ic-checking* t)
     (tell '(,(gensym "flight")
	    instance ((Token)  (AC-Flight)  (National-Flight))
	    with (
		  (flight-number 
		   (_ 1334))
		  (origin 
		   (_ Toronto))
		  (departure-time 
		   (_ 1005))
		  (max-passengers 
		   (_ 256))
		  (available-seats 
		   (2nd-class  85))
		  (destination
		   (_ Vancouver ))
		  (arrival-time
		   (_ 1400 ))
		  ))
	   )
     )
  )


(defun test-lisp-rep (object label value valuev history belief state &optional field)
  (let (h)
    (ndprog state (i)
      (setf i 0)
      (nd-loop (x (tok-get-prop object :test-lisp-rep))
	  (dbgn-print 'test-lisp-rep object x)
	(setf h (time-intersect history (car x) belief))
	(nd-if h
	  (nd-if valuev
	    (nd-progn
	     (success (list i (cdr x) h))
	     (setf i (+ 1 i))
	     )
	    (nd-if (eql value (cdr x))
	      (success (list i nil h)))
	    )
	  )
	)
      )
    )
  )



(defun push-lisp-val (object label history value)
  (push (cons history value) (tok-get-prop object :test-lisp-rep)
	)
  )

(defun set-test-lisp-rep (object label value history belief &rest optional)
  (push-lisp-val object label history value)
  )


(defun setup-lisp-rep nil
  (tell '(alarm with ((attribute (sss number)))) *theory* (theory-all-time *theory*)) 
  (declare-lisp-rep 'alarm "sss" #'test-lisp-rep #'set-test-lisp-rep *theory* 1)
  )


(defun test-inherit (&key (init t))
  (let (cc1 cc2 insins
	(h (default-history))
	(c1 (gensym "class"))
	(c2 (gensym "class2"))
	(ins (gensym "inst")))
    (if init (setq th (init-kb)))
    (setq cc1
      (tell `(,c1 instance ((s-class)) with ((attribute (x proposition)))) *theory* h))
    (dbgn-print 'c1 cc1)
    (setq cc2 (tell `(,c2 instance ((s-class)) isa ((,c1))
			with ((attribute (x number)))) *theory* h))
    (dbgn-print 'c2 cc2)
    (setq insins (tell `(,ins instance ((,c2)) with ((x (_ 15)))) *theory* h))
    (dbgn-print 'ins insins)
    (kb-print-token cc1)
    (kb-print-token cc2)
    (kb-print-token insins)
    (list cc1 cc2 insins)
    )
  )
