# include "Tools.h"
# include "Timit.h"
# include "RM.h"

# define DEFAULT_PHNTAB	TIMIT_DEFAULT_PHNTAB
# define DEFAULT_NINP	TIMIT_DEFAULT_NINP

int main(int argc, char **argv) {
  FILE *fp_byte;
  int  i, ninp, index, nlist, dummy;
  char  **plist;
  int  default_ninp = atoi(getenv("Y0_DEFAULT_NINP"));
  char *default_phntab = getenv("Y0_DEFAULT_PHNTAB");


  if(Scan_flag(argc, argv, "-h") == TRUE || argc <= 1 ||
     (fp_byte = Std_fopen(argv[argc - 1], "r")) == NULL) {
    fprintf(stderr, "Syntax:\t%s\n", *argv);
    fprintf(stderr, "\t-head\n");
    fprintf(stderr, "\t-ninp %d\n", default_ninp);
    fprintf(stderr, "\t-phntab %s\n", default_phntab);
    fprintf(stderr, "\t<byte file>\n");
    exit(1);
  }
  ninp = Scan_int(argc, argv, "-ninp", default_ninp);
  plist = Read_table(Scan_string(argc, argv, "-phntab",default_phntab),&nlist);

  if(Scan_flag(argc, argv, "-head")) {
    fread((char*) &dummy, sizeof(int), 1, fp_byte);
    fread((char*) &dummy, sizeof(int), 1, fp_byte);
    fread((char*) &dummy, sizeof(int), 1, fp_byte);
  }

  while((index = getc(fp_byte)) != EOF) {
    int pval = index & TIMIT_LABEL_MASK;

    for(i = 0; i < ninp; i++) printf("%3x", (uchar) getc(fp_byte));
    if(pval >= nlist) printf(" %d >= %d", pval, nlist);
    else printf(" %s", plist[pval]);
    if((index & TIMIT_SENT_MASK) != 0) printf(" *");
    printf("\n");
  }

  return(0);
}
