/* simple program to make a shadow linked copy of a directory tree */
/* Andrew Tridgell, July 1993 */
 
#include <stdio.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>


/*******************************************************************
recursively make a diectory.
********************************************************************/
void make_directory(char *name)
{
char *token;
char name2[1000];

strcpy(name2,name);

token = strtok(name2,"/");
while (token != NULL)
	{	
	mkdir(name2,0700);
	token = strtok(NULL,"/");
	if (token != NULL)
		token[-1] = '/';
	}
}


/*******************************************************************
this procedure is called recursively to do the work
********************************************************************/
void mkdirln(char *dirname,char *dest)
{
DIR *d;
struct dirent *dent;
struct stat st;

/* ajr 14 July 1993: make_directory(dest); replaced with following: */
if(mkdir(dest, 0777)) {
  fprintf(stderr, "mkdirln: %s: ", dest);
  perror(NULL);
  exit(errno);
}

d = opendir(dirname);
if (!d)
  {
	printf("couldn't open directory %s\n",dirname);
	return;
  }

/* loop on each file in the directory */
while (dent = readdir(d))
  {
	char *name2,*dest2;
	
	/* don't recurse on current or parent directory */
	if (strcmp(dent->d_name,".") == 0 || strcmp(dent->d_name,"..") == 0)
	  continue;

	/* make a couple of new strings for recursion */
	name2 = (char *)malloc(strlen(dirname)+strlen(dent->d_name)+2);
	dest2 = (char *)malloc(strlen(dirname)+strlen(dent->d_name)+2);
	strcpy(name2,dirname);
	strcat(name2,"/");
	strcat(name2,dent->d_name);
	strcpy(dest2,dest);
	strcat(dest2,"/");
	strcat(dest2,dent->d_name);

	/* stat the file to see what type it is */
	if (stat(name2,&st) != 0)
	  {
		printf("couldn't stat %s in directory %s\n",dent->d_name,dirname);
		if (name2) free(name2);
		if (dest2) free(dest2);
		continue;
	  }

	if (!name2 || !dest2)
	  {
		printf("out of memory!\n");
		if (name2) free(name2);
		if (dest2) free(dest2);
		return;
	  }

	/* if a directory then recurse, otherwise make the link */
	if (S_ISDIR(st.st_mode))
	  mkdirln(name2,dest2);
	else
	  {
		if (symlink(name2,dest2) != 0)
		  printf("symlink failed %s -%s\n",name2,dest2);
	  }
	free(name2);
	free(dest2);
  }
closedir(d);
}


int main(int argc,char *argv[])
{
if (argc < 3)
  {
	printf("Usage: mkdirln <source dir> <dest dir>\n");
	exit(0);
  }
mkdirln(argv[1],argv[2]);
return(0);
}
