# include "Tools.h"
# include "Timit.h"
# include "RM.h"

# define DEFAULT_WORD	"/home/dsl1/ajr/lib/pcdsril.dct"
# define DEFAULT_SENT	"/home/dsl1/ajr/rm1_doc/al_sents.snr"
# define DEFAULT_PREFIX	"/home/hope/ajr/rm1/true/"
# define DEFAULT_PHN_SUFFIX	".phn"
# define DEFAULT_WRD_SUFFIX	".wrd"
# define DEFAULT_DCT_SUFFIX	".dct"
# define MAX_LINE	256
# define MAX_NWORD	32

typedef struct dict_struct {
  int    nphone;
  char **phone;
} dict_type;

# define FILENAMESIZE 256

int main(int argc, char **argv) {
  FILE	*fp_txt;
  int   textsize, linesize, verbose;
  char  *prefix, *phn_suffix, *wrd_suffix, *dct_suffix, filename[FILENAMESIZE];
  char *text, *line, *wordtab = Hash_init(RM_NWORD);

  if(Scan_flag(argc, argv, "-h") == TRUE || argc < 1) {
    fprintf(stderr, "Syntax:\t%s\n", *argv);
    fprintf(stderr, "\t-verbose\n");
    fprintf(stderr, "\t-word %s\n", DEFAULT_WORD);
    fprintf(stderr, "\t-sent %s\n", DEFAULT_SENT);
    fprintf(stderr, "\t-prefix %s\n", DEFAULT_PREFIX);
    fprintf(stderr, "\t-phn_suffix %s\n", DEFAULT_PHN_SUFFIX);
    fprintf(stderr, "\t-wrd_suffix %s\n", DEFAULT_WRD_SUFFIX);
    fprintf(stderr, "\t-dct_suffix %s\n", DEFAULT_DCT_SUFFIX);
    exit(1);
  }

  verbose = Scan_flag(argc, argv, "-verbose");
  prefix = Scan_string(argc, argv, "-prefix", DEFAULT_PREFIX);
  phn_suffix = Scan_string(argc, argv, "-phn_suffix", DEFAULT_PHN_SUFFIX);
  wrd_suffix = Scan_string(argc, argv, "-wrd_suffix", DEFAULT_WRD_SUFFIX);
  dct_suffix = Scan_string(argc, argv, "-dct_suffix", DEFAULT_DCT_SUFFIX);

  fp_txt = Panic_fopen(Scan_string(argc, argv, "-word", DEFAULT_WORD), "r");
  Panic_fseek(fp_txt, (long) 0, 2);
  textsize = ftell(fp_txt);
  text = Panic_malloc(textsize);
  Panic_fseek(fp_txt, (long) 0, 0);
  Panic_fread(text, 1, textsize, fp_txt);
  Panic_fclose(fp_txt);

  for(line = text; line < text + textsize; line += linesize) {
    int i;

    for(linesize = 0; line[linesize] != '\n' && 
	line + linesize < text + textsize; linesize++);
    line[linesize++] = '\0';

    if(line[0] != ';') {
      dict_type *dict_entry;
      int   wordc;
      char *key;
      char *wordv[MAX_NWORD];

      key = strtok(line, " ");
      for(i = 0; i < MAX_NWORD && (wordv[i] = strtok(NULL, " ")) != NULL; i++);
      wordc = i;

      if(wordc != 0) {
	dict_entry = (typeof(dict_entry)) Panic_malloc(sizeof(*dict_entry));
	dict_entry->nphone = wordc;
	dict_entry->phone = (char**) Panic_malloc(sizeof(char*) * wordc);
      
	for(i = 0; i < wordc; i++)
	  dict_entry->phone[i] = wordv[i];

	Hash_add(wordtab, key, (char*) dict_entry);
      }
    }
  }

  fp_txt = Panic_fopen(Scan_string(argc, argv, "-sent", DEFAULT_SENT), "r");
  Panic_fseek(fp_txt, (long) 0, 2);
  textsize = ftell(fp_txt);
  text = Panic_malloc(textsize);
  Panic_fseek(fp_txt, (long) 0, 0);
  Panic_fread(text, 1, textsize, fp_txt);
  Panic_fclose(fp_txt);

  for(line = text; line < text + textsize; line += linesize) {
    int i;

    for(linesize = 0; line[linesize] != '\n' && 
	line + linesize < text + textsize; linesize++);
    line[linesize++] = '\0';

    if(line[0] != ';') {
      int wordc = 0;
      char *wordv[MAX_NWORD];

      /* first call */
      wordv[wordc] = strtok(line, " ");
      while(++wordc < MAX_NWORD && (wordv[wordc] = strtok(NULL, " ")) != NULL);

      /* ignore TIMIT sentences (sa*), do all RM sentences */
      if(wordv[wordc - 1][2] != 'A') {
	FILE *fp_phn, *fp_wrd, *fp_dct;

	/* munge last word into a filename */
	wordv[wordc - 1][1] = tolower(wordv[wordc - 1][1]);
	wordv[wordc - 1][2] = tolower(wordv[wordc - 1][2]);
	wordv[wordc - 1][strlen(wordv[wordc - 1]) - 1] = '\0';

	if(verbose) printf("%s\n", wordv[wordc - 1]);

	strcpy(filename, prefix);
	strcat(filename, wordv[wordc - 1] + 1);
	strcat(filename, phn_suffix);
	fp_phn = Panic_fopen(filename, "w");

	strcpy(filename, prefix);
	strcat(filename, wordv[wordc - 1] + 1);
	strcat(filename, wrd_suffix);
	fp_wrd = Panic_fopen(filename, "w");

	strcpy(filename, prefix);
	strcat(filename, wordv[wordc - 1] + 1);
	strcat(filename, dct_suffix);
	fp_dct = Panic_fopen(filename, "w");

	fprintf(fp_phn, "0\t0\th#\n");
	fprintf(fp_dct, "@INIT h#\n");
	for(i = 0; i < wordc - 1; i++) {
	  dict_type *dict_entry = (dict_type*) Hash_find(wordtab, wordv[i]);
	  int j;

	  fprintf(fp_dct, "%s", wordv[i]);

	  if(dict_entry == NULL)
	    fprintf(stderr, "%s: Can't find entry for %s\n", *argv, wordv[i]);
	  else 
	    for(j = 0; j < dict_entry->nphone; j++) {
	      fprintf(fp_phn, "0\t0\t%s\n", dict_entry->phone[j]);
	      fprintf(fp_dct, " %s", dict_entry->phone[j]);
	    }
	  fprintf(fp_wrd, "0\t0\t%s\n", wordv[i]);
	  fprintf(fp_dct, "\n");
	}	
	fprintf(fp_phn, "0\t0\th#\n");
	fprintf(fp_dct, "@QUIT h#\n");
	Panic_fclose(fp_phn);
	Panic_fclose(fp_wrd);
	Panic_fclose(fp_dct);
      }	
    }
  }
  return(0);
}
