# include "Tools.h"
# include "Timit.h"
# include "RM.h"

# define DEFAULT_PREFIX RM1_LOCAL_PATH
# define DEFAULT_SUFFIX ".lna"
# define DEFAULT_NOUT	RM_NPHONE

int main(int argc, char **argv) {
  FILE   *fp_dbl, *fp_act;
  int    nout, size, verbose;
  char   *suffix, *prefix;
  uchar  *frame;
  static char base_name[MAX_NAME_SIZE], file_name[MAX_NAME_SIZE];

  if(Scan_flag(argc, argv, "-h") == TRUE || argc <= 2 ||
     (fp_dbl = fopen(argv[argc - 2], "r")) == NULL ||
     (fp_act = Std_fopen(argv[argc - 1], "r")) == NULL) {
    fprintf(stderr, "Syntax:\t%s\n", *argv);
    fprintf(stderr, "\t-verbose\n");
    fprintf(stderr, "\t-nout %d\n", DEFAULT_NOUT);
    fprintf(stderr, "\t-prefix %s\n", DEFAULT_PREFIX);
    fprintf(stderr, "\t-suffix %s\n", DEFAULT_SUFFIX);
    fprintf(stderr, "\t<filename file >\n");
    fprintf(stderr, "\t<-|activation file>\n");
    exit(1);
  }

  verbose = Scan_flag(argc, argv, "-verbose");
  nout   = Scan_int(argc, argv, "-nout", DEFAULT_NOUT);
  prefix = Scan_string(argc, argv, "-prefix", DEFAULT_PREFIX);
  suffix = Scan_string(argc, argv, "-suffix", DEFAULT_SUFFIX);

  size = nout + 1;
  if((frame = (uchar*) Char_array(size)) == NULL)
    Panic("%s: oops, no malloc space...\n", *argv);
  while(fscanf(fp_dbl, "%s\n", base_name) == 1)
    if(base_name[0] != '#') {
      FILE *stream;
      strncpy(file_name, prefix, MAX_NAME_SIZE);
      strncat(file_name, base_name, MAX_NAME_SIZE);
      strncat(file_name, suffix, MAX_NAME_SIZE);
      stream = Panic_fopen(file_name, "w");
      frame[0] = 0;
      while((frame[0] & TIMIT_SENT_MASK) == 0 && 
	    fread(frame, sizeof(*frame), size, fp_act) == size)
	if(fwrite(frame, sizeof(uchar), size, stream) != size)
	  Panic("%s: oops, can`t write %s...\n", *argv, file_name);
      if(verbose == TRUE) printf("%d\t%s\n", ftell(stream), file_name);
      if((frame[0] & TIMIT_SENT_MASK) == 0)
	Panic("%s: premature EOF on: %s\n", *argv, argv[argc - 1]);
      Panic_fclose(stream);
    }	
  if(fgetc(fp_act) != EOF)
    Panic("%s: EOF on %s before EOF on %s\n", *argv,argv[argc-2],argv[argc-1]);
  return(0);
}
