/* Implements the Allophone to phone as of "Speaker-Independent Phone
Recognition Using Hidden Markov Models", Kai-Fu Lee and Hsiao-Wuen Hon, IEEE
ASSP, vol 37, no 11, Nov 1989.  */

# include "Tools.h"

char *Allophone2phone(char *phone) {
  if(strcmp(phone, "j")    == 0) return("jh");
  if(strcmp(phone, "ux")   == 0) return("uw");
  if(strcmp(phone, "el")   == 0) return("l");
  if(strcmp(phone, "axr")  == 0) return("er");
  if(strcmp(phone, "em")   == 0) return("m");
  if(strcmp(phone, "en")   == 0) return("n");
  if(strcmp(phone, "nx")   == 0) return("n");
  if(strcmp(phone, "eng")  == 0) return("ng");
  if(strcmp(phone, "hv")   == 0) return("hh");
  if(strcmp(phone, "sh")   == 0) return("zh");
  if(strcmp(phone, "ao")   == 0) return("aa");
  if(strcmp(phone, "ih")   == 0) return("ix");
  if(strcmp(phone, "ah")   == 0) return("ax");
  if(strcmp(phone, "ax-h") == 0) return("ax");
  if(strcmp(phone, "pcl")  == 0) return("sil");
  if(strcmp(phone, "tcl")  == 0) return("sil");
  if(strcmp(phone, "kcl")  == 0) return("sil");
  if(strcmp(phone, "qcl")  == 0) return("sil");
  if(strcmp(phone, "bcl")  == 0) return("sil");
  if(strcmp(phone, "dcl")  == 0) return("sil");
  if(strcmp(phone, "gcl")  == 0) return("sil");
  if(strcmp(phone, "epi")  == 0) return("sil");
  if(strcmp(phone, "h#")   == 0) return("sil");
  if(strcmp(phone, "#h")   == 0) return("sil");
  if(strcmp(phone, "pau")  == 0) return("sil");
  return(phone);
}

/* This maps the TIMIT allophone set into the intermediate represention that
** can also be reached from the KFL SPHINX set 
*/
char *Allophone2rmphone(char *phone) {
  if(strcmp(phone, "ux")   == 0) return("uw");
  if(strcmp(phone, "axr")  == 0) return("er");
  if(strcmp(phone, "ax-h") == 0) return("ax");
  if(strcmp(phone, "hv")   == 0) return("hh");
  if(strcmp(phone, "zh")   == 0) return("z");
  if(strcmp(phone, "el")   == 0) return("l");
  if(strcmp(phone, "em")   == 0) return("m");
  if(strcmp(phone, "eng")  == 0) return("ng");
  if(strcmp(phone, "nx")   == 0) return("n");
  if(strcmp(phone, "pau")  == 0) return("h#");
  if(strcmp(phone, "epi")  == 0) return("h#");
  if(strcmp(phone, "q")    == 0) return("h#");
  return(phone);
}

/* This maps the old RM set onto the new RM set - well not exactly - you still
   need to take out multiple stops */

char *rmphone2rm1phone(char *phone) {
  if(strcmp(phone, "pcl")  == 0) return("p");
  if(strcmp(phone, "tcl")  == 0) return("t");
  if(strcmp(phone, "kcl")  == 0) return("k");
  if(strcmp(phone, "bcl")  == 0) return("b");
  if(strcmp(phone, "dcl")  == 0) return("d");
  if(strcmp(phone, "gcl")  == 0) return("g");
  if(strcmp(phone, "en")   == 0) return("n");
  return(phone);
}

/* This maps TIMIT to Andrej's DARPA  - well not exactly - you still
   need to take out multiple stops and sil */

char *allophone2aljphone(char *phone) {
  if(strcmp(phone, "h#")   == 0) return("sil");
  if(strcmp(phone, "pau")  == 0) return("sil");
  if(strcmp(phone, "epi")  == 0) return("sil");
  if(strcmp(phone, "pcl")  == 0) return("p");
  if(strcmp(phone, "pcl")  == 0) return("p");
  if(strcmp(phone, "tcl")  == 0) return("t");
  if(strcmp(phone, "kcl")  == 0) return("k");
  if(strcmp(phone, "bcl")  == 0) return("b");
  if(strcmp(phone, "dcl")  == 0) return("d");
  if(strcmp(phone, "gcl")  == 0) return("g");
  if(strcmp(phone, "ax-h") == 0) return("ax");
  if(strcmp(phone, "ux")   == 0) return("uw");
  if(strcmp(phone, "em")   == 0) return("m");
  if(strcmp(phone, "eng")  == 0) return("ng");
  if(strcmp(phone, "hv")   == 0) return("hh");
  if(strcmp(phone, "q")    == 0) return("dx");
  return(phone);
}

/* this mapping done for the ACTS project */

char *Allophone2apuphone(char *phone) {
  if(strcmp(phone, "pcl")  == 0) return("p");
  if(strcmp(phone, "tcl")  == 0) return("t");
  if(strcmp(phone, "kcl")  == 0) return("k");
  if(strcmp(phone, "bcl")  == 0) return("b");
  if(strcmp(phone, "dcl")  == 0) return("d");
  if(strcmp(phone, "gcl")  == 0) return("g");
  return(phone);
}

/* this maps all the TIMIT allophones to a symbol indicating thier voicing */

char *Allophone2voicing(char *phone) {
  if(strcmp(phone, "h#")   == 0) return("u");
  if(strcmp(phone, "pau")  == 0) return("u");
  if(strcmp(phone, "epi")  == 0) return("u");
  if(strcmp(phone, "eh")   == 0) return("v");
  if(strcmp(phone, "ih")   == 0) return("v");
  if(strcmp(phone, "ao")   == 0) return("v");
  if(strcmp(phone, "ae")   == 0) return("v");
  if(strcmp(phone, "aa")   == 0) return("v");
  if(strcmp(phone, "ah")   == 0) return("v");
  if(strcmp(phone, "uw")   == 0) return("v");
  if(strcmp(phone, "uw")   == 0) return("v");
  if(strcmp(phone, "uh")   == 0) return("v");
  if(strcmp(phone, "er")   == 0) return("v");
  if(strcmp(phone, "ux")   == 0) return("v");
  if(strcmp(phone, "ay")   == 0) return("v");
  if(strcmp(phone, "oy")   == 0) return("v");
  if(strcmp(phone, "ey")   == 0) return("v");
  if(strcmp(phone, "iy")   == 0) return("v");
  if(strcmp(phone, "aw")   == 0) return("v");
  if(strcmp(phone, "ow")   == 0) return("v");
  if(strcmp(phone, "ax")   == 0) return("v");
  if(strcmp(phone, "axr")  == 0) return("v");
  if(strcmp(phone, "ix")   == 0) return("v");
  if(strcmp(phone, "ax-h") == 0) return("v");
  if(strcmp(phone, "l")    == 0) return("v");
  if(strcmp(phone, "el")   == 0) return("v");
  if(strcmp(phone, "r")    == 0) return("v");
  if(strcmp(phone, "w")    == 0) return("v");
  if(strcmp(phone, "y")    == 0) return("v");
  if(strcmp(phone, "hh")   == 0) return("u");
  if(strcmp(phone, "hv")   == 0) return("v");
  if(strcmp(phone, "s")    == 0) return("u");
  if(strcmp(phone, "sh")   == 0) return("u");
  if(strcmp(phone, "z")    == 0) return("u");
  if(strcmp(phone, "zh")   == 0) return("u");
  if(strcmp(phone, "ch")   == 0) return("u");
  if(strcmp(phone, "jh")   == 0) return("u");
  if(strcmp(phone, "th")   == 0) return("u");
  if(strcmp(phone, "dh")   == 0) return("u");
  if(strcmp(phone, "f")    == 0) return("u");
  if(strcmp(phone, "v")    == 0) return("v");
  if(strcmp(phone, "m")    == 0) return("v");
  if(strcmp(phone, "em")   == 0) return("v");
  if(strcmp(phone, "n")    == 0) return("v");
  if(strcmp(phone, "en")   == 0) return("v");
  if(strcmp(phone, "ng")   == 0) return("v");
  if(strcmp(phone, "eng")  == 0) return("v");
  if(strcmp(phone, "nx")   == 0) return("v");
  if(strcmp(phone, "p")    == 0) return("u");
  if(strcmp(phone, "b")    == 0) return("u");
  if(strcmp(phone, "t")    == 0) return("u");
  if(strcmp(phone, "d")    == 0) return("u");
  if(strcmp(phone, "k")    == 0) return("u");
  if(strcmp(phone, "g")    == 0) return("u");
  if(strcmp(phone, "pcl")  == 0) return("u");
  if(strcmp(phone, "bcl")  == 0) return("u");
  if(strcmp(phone, "tcl")  == 0) return("u");
  if(strcmp(phone, "dcl")  == 0) return("u");
  if(strcmp(phone, "kcl")  == 0) return("u");
  if(strcmp(phone, "gcl")  == 0) return("u");
  if(strcmp(phone, "dx")   == 0) return("u");
  if(strcmp(phone, "q")    == 0) return("u");
  Panic("Allophone2voicing: lookup failed for: %s\n", phone);
}
