# include "Tools.h"

#ifdef TC
float ChanInFloat(Channel *c) {
  float value;

  #pragma asm
    LDLP    ?ws-1
    LDL     ?ws+1
    LDC     1
    BCNT
    IN
  #pragma endasm
  return(value);
}

void ChanOutFloat(Channel *c, float value) {
  #pragma asm
    LDLP    ?ws+2
    LDL     ?ws+1
    LDC     1
    BCNT
    OUT
  #pragma endasm
}

int ChanInBlock(Channel *link, char *data) {
  int size = ChanInInt(link, size);
  if(size != 0) ChanIn(link, data, size);
  return(size);
}

void ChanOutBlock(Channel *link, char *data, int size) {
  ChanOutInt(link, size);
  if(size != 0) ChanOut(link, data, size);
}
#else
float ChanInFloat()  { Panic("ChanInFloat() called\n"); }
void  ChanOutFloat() { Panic("ChanOutFloat() called\n"); }
int   ChanInBlock()  { Panic("ChanInBlock() called\n"); }
void  ChanOutBlock() { Panic("ChanOutBlock() called\n"); }
#endif
