/* watch out, these are all 0 .. order inclusive arrays */

# include "Tools.h"
# define MAX_ORDER 128

float lpredict(float *adc, int wsize, float *acf, float *ref, float *lpc, int
	       order) {
  int   i, j;
  float e, ci, sum;
  float tmp[MAX_ORDER];
  
  if(order >= MAX_ORDER) Panic("lpc: %d exceeds MAX_ORDER\n", order);
   
  for(i = 0; i <= order; i++) {
    sum = 0.0;
    for(j = 0; j < wsize - i; j++) sum += adc[j] * adc[j + i];
    acf[i] = sum;
  }
  
  /* find lpc coefficients */
  e = acf[0];
  lpc[0] = 1.0;
  for(i = 1; i <= order; i++) {
    ci = 0.0;
    for(j = 1; j < i; j++) ci += lpc[j] * acf[i-j];
    ref[i] = ci = (acf[i] - ci) / e;
    lpc[i] = ci;
    for(j = 1; j < i; j++) tmp[j] = lpc[j] - ci * lpc[i-j];
    for(j = 1; j < i; j++) lpc[j] = tmp[j];
    e = (1 - ci * ci) * e;
  }
  return(e);
}

void ref2area(float *ref, float *area, int order) {
  int   i;

  for(i = 1; i <= order; i++)
    area[i] = (1.0 - ref[i]) / (1.0 + ref[i]);
}

#define ALMOST1 0.99999
void ref2logarea(float *ref, float *logarea, int order) {
  int   i;

  for(i = 1; i <= order; i++) {
    if(ref[i] > ALMOST1) logarea[i] = log((1.0 - ALMOST1) / (1.0 + ALMOST1));
    else if(ref[i] < -ALMOST1) logarea[i] = log((1.0 + ALMOST1)/(1.0-ALMOST1));
    else logarea[i] = log((1.0 - ref[i]) / (1.0 + ref[i]));
  }
}

void ref2truearea(float *ref, float *area, int order) {
  int   i;

  area[1] = (1.0 - ref[1]) / (1.0 + ref[1]);
  for(i = 2; i <= order; i++) 
    area[i] = area[i - 1] * (1.0 - ref[i]) / (1.0 + ref[i]);
}
