# include "Tools.h"

/* multiply a m by n matrix with a n by p to give a m by p matrix */

void Matrix_transpose(float **m0, float **m1, int m, int n) {
  int i, j;

  if(m0 == m1) {
    if(m != n)
      Panic("Matrix_transpose: same memory but different dimensions!\n");

    for(i = 0; i < n; i++)
      for(j = 0; j < i; j++) {
	float tmp = m0[i][j];
	m0[i][j] = m0[j][i];
	m0[j][i] = tmp;
      }
  }
  else
    for(i = 0; i < m; i++)
      for(j = 0; j < n; j++)
	m1[j][i] = m0[i][j];
}

void Matrix_multiply(float **m0, float **m1, float **m2, int m, int n, int p) {
  int i, j, k;

  for(i = 0; i < n; i++)
    for(j = 0; j < p; j++) {
      float sum = 0.0;
      
      for(k = 0; k < n; k++) sum += m0[i][k] * m1[k][j];
      m2[i][j] = sum;
    }
}

# include "nrutil.h"

void lubksb(float**, int, int*, float*);
void ludcmp(float**, int, int*, float*);

float Matrix_invert(float **original, float **inverse, int n) {
  float **worksp = matrix(1, n, 1, n), *col = vector(1, n), sign, lndet = 0.0;
  int i, j, *indx = ivector(1, n);
  
  for(i = 0; i < n; i++)
    for(j = 0; j < n; j++)
      worksp[i + 1][j + 1] = original[i][j];

  ludcmp(worksp, n, indx, &sign);

  for(j = 1; j <= n; j++) {
    if(worksp[j][j] < 0.0) sign = -sign;
    lndet += log(fabs(worksp[j][j]));

    for(i = 1; i <= n; i++) col[i] = 0.0;
    col[j] = 1.0;
    lubksb(worksp, n, indx, col);
    for(i = 1; i <= n; i++) inverse[i - 1][j - 1] = col[i];
  }   
     
  if(sign == -1)
    Panic("Matrix_invert: Determinant of covariance matrix is negative\n");

  free_matrix(worksp, 1, n, 1, n);
  free_vector(col, 1, n);
  free_ivector(indx, 1, n);

  return(lndet);
}

void jacobi(float **a, int n, float d[], float **v, int *nrot);

void Matrix_rseigen(float **original, float *evalue, float **evector, int n) {
  float **worksp = matrix(1, n, 1, n), **evectr = matrix(1, n, 1, n);
  int i, j, k, nrot, *rank = Panic_int_array(n);

  for(i = 0; i < n; i++)
    for(j = 0; j < n; j++)
      worksp[i + 1][j + 1] = original[i][j];

  jacobi(worksp, n, evalue - 1, evectr, &nrot);

  for(i = 0; i < n; i++) {
    float tmp;

    if(evalue[i] < 0.0) evalue[i] = 0.0; /* numerical error */
    tmp = evalue[i];
    for(j = 0; j < i && evalue[i] < evalue[j]; j++);
    for(k = i; k > j; k--) {
      evalue[k] = evalue[k - 1];
      rank[k] = rank[k - 1];
    }
    evalue[j] = tmp;
    rank[j] = i;
  }

  for(i = 0; i < n; i++)
    for(j = 0; j < n; j++)
      evector[i][j] = evectr[rank[i] + 1][j + 1];
  
  Panic_free((char*) rank);
  free_matrix(worksp, 1, n, 1, n);
  free_matrix(evectr, 1, n, 1, n);
}
