# include "Tools.h"

void Noise(float *data, int nsample, double noiselevel, double relfcutoff) {
  float beta  = 2.0 * M_PI * relfcutoff;
  float alpha = exp(-beta);
  float gain  = noiselevel / sqrt(beta * beta / (1.0 - alpha * alpha));
  float noise = 0.0;
  int i;

  for(i = 0; i < nsample; i++) {
    noise = alpha * noise + beta * Gasdev(0);
    data[i] += gain * noise;
  }
}
