/* This lot does non-linear frequency transformations */
# include "Tools.h"

/******************************************************************************
	author =	"R. A. W. Bladon and B. Lindblom",
	month =         "May",
	year =          "1981",
	journal =	"Journal of the Acoustical Society of America",
	title =         "Modeling the Judgement of Vowel Quality Differences",
	volume =	"69"
*/

double Bark_to_hz(double bark) {
    return(650.0 * sinh(bark / 7.0));
}

double Hz_to_bark(double hz) {
    double tmp = hz / 650.0;
    return(7.0 * log(tmp + sqrt(tmp * tmp + 1.0)));
}

/******************************************************************************
	author=		"E. Zwicker and E. Terhart",
	title=		"Analytical expressions for critical-band rate and
			 critical bandwidth as a function of frequency",
	journal=	jasa,
	pages=		"1523-1525",
	volume=		"68(5)",
	year=		1980}

static float bark2hztab[25] = {0.0, 100.0, 200.0, 300.0, 400.0, 510.0, 630.0,
				 770.0, 920.0, 1080.0, 1270.0, 1480.0, 1720.0,
				 2000.0, 2320.0, 2700.0, 3150.0, 3700.0,
				 4400.0, 5300.0, 6400.0, 7700.0, 9500.0,
				 12000.0, 15500.0};

double Bark2Hz(double bark) {
  int lindex = bark;

  if(bark < 0.0 || bark >= 24.0)
    Panic("Bark2Hz; out of range: %f\n", bark);

  return(bark2hztab[lindex] + 0.0);
}

double Hz2Bark(double hz) {
  Panic("Not written yet\n");
}
*/

/******************************************************************************

	author =	"Donald D. Greenwood",
	title=		"A Cochlear Frequency-Position Function for Several
	                 Species -- 29 Years Later",
	journal =	"Journal of the Acoustical Society of America",
	volume =	"87(6)",
	month =         jun,
	year =          1990,
*/

double Basilarmm2Hz(double basilarmm) {
  return(165.4 * (pow(10.0, 0.06 * basilarmm) - 1.0));
}

double Hz2Basilarmm(double hz) {
  return(log10(hz / 165.4 + 1.0) / 0.06);
}

/******************************************************************************
  Zwislocki(1965)
*/

double Mel2Hz(double mel) {
  return((exp(mel / 1125.0) - 1.0) / 0.0016);
}

double Hz2Mel(double hz) {
  return(1125.0 * log(0.0016 * hz + 1.0));
}

/******************************************************************************
  formula from JohnH taken from verion 4.0 of the auditory model
  latest erb function circa. 1989 from BBG & CJM
  derived from erb = 24.7 * ( 4.37e-3 * f +  1 )
*/

static double limit = 24.7  ; /* limit = k1 */
static double Q     = 9.265 ; /* Q = 1. / ( k1 * k2 ) */

double Hz2Erb(double frequency) {
  return ( limit + frequency / Q ) ;
}

double Hz2ErbScale(double frequency) {
  return(log(1.0 + frequency / Q / limit ) * Q );
}

double ErbScale2Hz(double E) {
  return((exp(E / Q) - 1.0) * Q * limit);
}
