# include "Tools.h"
# define WINDOWLENGTH	0.10 /* in seconds */
# define POWER_THRESHOLD (1.0 / 256.0)
# define NORMALISED_RMS	 1024.0

double Normalise(float *data, int nsample, int fsample) {
  float *squared;
  float sum0, mean, scale, total_power;
  int	windowsize = WINDOWLENGTH * fsample;
  int	nwindow = nsample / windowsize;
  int i, j;

  squared = Panic_float_array(nwindow);

  /* zero mean */
  sum0 = 0.0;
  for(i = 0; i < nsample; i++) sum0 += data[i];
  mean = sum0 / nsample;
  for(i = 0; i < nsample; i++) data[i] -= mean;

  /* compute s.d. of all sections of windowed waveform */
  total_power = 0.0;
  for(i = 0; i < nwindow; i++) {
    float sum2 = 0.0;
    for(j = i * windowsize; j < (i + 1) * windowsize; j++)
      sum2 += data[j] * data[j];
    squared[i] = sum2 / windowsize;
    total_power += squared[i];
  }

  /* compute s.d. of those sections likely to be speech */
  {
    float limit = POWER_THRESHOLD * total_power / nwindow;
    float spoken_power = 0.0;
    int	  spoken_nframe = 0;

    for(i = 0; i < nwindow; i++) {
      if(squared[i] > limit) {
	spoken_power += squared[i];
	spoken_nframe++;
      }
    }
    scale = NORMALISED_RMS / sqrt(spoken_power / spoken_nframe);
  }

  /* and scale the waveform */
  for(i = 0; i < nsample; i++) data[i] *= scale;
  Panic_free((char*) squared);
  return(1.0 / scale);
}
