# include "Tools.h"

#define      N          6     /* No. of ints used to define a machine */

int Read_machine(Machine_type *p, FILE *fp_machine) {
  int size = (p->sta_op * (p->sta_op - 1) -
	      p->hidden * (p->hidden - 1)) / 2 +
	     (p->length - p->sta_op) * p->sta_op;

  if(fread((char*) p, sizeof(int), N, fp_machine) != N) return(FALSE);

  /* read in the outputs */
  if(fread((char*) p->node_op, sizeof(p->node_op[0]), p->length,
	   fp_machine) != p->length) return(FALSE);

  /* read in the weights */
  if(fread((char*) p->weight[0], sizeof(p->weight[0][0]), size,
	   fp_machine) != size) return(FALSE);

  /* read in the smoothed changes */
  if(fread((char*) p->smooth[0], sizeof(p->smooth[0][0]), size,
	   fp_machine) != size) return(FALSE);
  return(TRUE);
}

int Read_swal_machine(Machine_type *p, FILE *fp_machine) {
  int size = (p->sta_op * (p->sta_op - 1) -
	      p->hidden * (p->hidden - 1)) / 2 +
	     (p->length - p->sta_op) * p->sta_op;

  if(Swal_fread((char*) p, sizeof(int), N, fp_machine) != N) return(FALSE);

  /* read in the outputs */
  if(Swal_fread((char*) p->node_op, sizeof(p->node_op[0]), p->length,
	   fp_machine) != p->length) return(FALSE);

  /* read in the weights */
  if(Swal_fread((char*) p->weight[0], sizeof(p->weight[0][0]), size,
	   fp_machine) != size) return(FALSE);

  /* read in the smoothed changes */
  if(Swal_fread((char*) p->smooth[0], sizeof(p->smooth[0][0]), size,
	   fp_machine) != size) return(FALSE);
  return(TRUE);
}
