# include "Tools.h"
# include "Timit.h"

int Read_phn_file(char *basename, struct phnline *line, int max_nline) {
  FILE	*phn_file;
  int   nline;
  char  *filename;

  filename = Panic_malloc(strlen(basename) + strlen(".phn") + 1);
  strcpy(filename, basename);
  strcat(filename, ".phn");
  phn_file = Panic_fopen(filename, "r");

  for(nline = 0; nline < max_nline && fscanf(phn_file, "%d%d%s",
      &line[nline].init, &line[nline].quit, line[nline].label) == 3;
      nline++);
  
  if(nline == max_nline)
    Panic("Read_phn_file: overflow of max_nline: %d\n", max_nline);

  if(strcmp(line[nline - 1].label, "h#") != 0) {
    FILE *act_file;
    
    line[nline].init = line[nline - 1].quit;
    strcpy(filename, basename);
    strcat(filename, ".adc");
    act_file = Panic_fopen(filename, "r");
    fseek(act_file, 0L, 2);
    line[nline].quit = (ftell(act_file) - TIMIT_HEADER_SIZE) /
      TIMIT_BYTES_PER_SAMPLE;
    Panic_fclose(act_file);
    strcpy(line[nline].label, "h#");
    nline++;
  }

  Panic_fclose(phn_file);
  Panic_free(filename);
  return(nline);
}
