# include "Tools.h"

void Scale_one_vector(float *output, float* change, int size,
		      register float scale) {
  int 	i, size0x10 = size / 0x10;

  for(i = 0; i < size0x10; i++) {
    change[0x0] += scale * output[0x0];
    change[0x1] += scale * output[0x1];
    change[0x2] += scale * output[0x2];
    change[0x3] += scale * output[0x3];
    change[0x4] += scale * output[0x4];
    change[0x5] += scale * output[0x5];
    change[0x6] += scale * output[0x6];
    change[0x7] += scale * output[0x7];
    change[0x8] += scale * output[0x8];
    change[0x9] += scale * output[0x9];
    change[0xa] += scale * output[0xa];
    change[0xb] += scale * output[0xb];
    change[0xc] += scale * output[0xc];
    change[0xd] += scale * output[0xd];
    change[0xe] += scale * output[0xe];
    change[0xf] += scale * output[0xf];
    change += 0x10;
    output += 0x10;
  }

  for(i = 0; i < size % 0x10; i++) *change++ += scale * *output++;
}

void Scale_two_vectors(register float *output, register float *delta,
		       register float *weight, register float *change,
		       int size, register float scale) {
  int 	i, size0x10 = size / 0x10;

  for(i = 0; i < size0x10; i++) {
    change[0x0] += scale * output[0x0];
    change[0x1] += scale * output[0x1];
    change[0x2] += scale * output[0x2];
    change[0x3] += scale * output[0x3];
    change[0x4] += scale * output[0x4];
    change[0x5] += scale * output[0x5];
    change[0x6] += scale * output[0x6];
    change[0x7] += scale * output[0x7];
    change[0x8] += scale * output[0x8];
    change[0x9] += scale * output[0x9];
    change[0xa] += scale * output[0xa];
    change[0xb] += scale * output[0xb];
    change[0xc] += scale * output[0xc];
    change[0xd] += scale * output[0xd];
    change[0xe] += scale * output[0xe];
    change[0xf] += scale * output[0xf];
    change += 0x10;
    output += 0x10;
    delta[0x0]  += scale * weight[0x0];
    delta[0x1]  += scale * weight[0x1];
    delta[0x2]  += scale * weight[0x2];
    delta[0x3]  += scale * weight[0x3];
    delta[0x4]  += scale * weight[0x4];
    delta[0x5]  += scale * weight[0x5];
    delta[0x6]  += scale * weight[0x6];
    delta[0x7]  += scale * weight[0x7];
    delta[0x8]  += scale * weight[0x8];
    delta[0x9]  += scale * weight[0x9];
    delta[0xa]  += scale * weight[0xa];
    delta[0xb]  += scale * weight[0xb];
    delta[0xc]  += scale * weight[0xc];
    delta[0xd]  += scale * weight[0xd];
    delta[0xe]  += scale * weight[0xe];
    delta[0xf]  += scale * weight[0xf];
    delta  += 0x10;
    weight += 0x10;
  }

  for(i = 0; i < size % 0x10; i++) {
    *change++ += *output++ * scale;
    *delta++  += *weight++ * scale;
  }
}

