# include "Tools.h"

int Sizeof_weight_matrix(Machine_type *p) {
  return(((p->sta_op * (p->sta_op - 1) - 
	   p->hidden * (p->hidden - 1)) / 2 +
	  (p->length - p->sta_op) * p->sta_op) * sizeof(Tools_type));
}

void Set_weight_matrix(Machine_type *p, Tools_type **write, Tools_type value) {
  int i, j;

  for(i = p->hidden; i < p->sta_op; i++)
    for(j = 0; j < i; j++) write[i][j] = value;
  for(i = p->sta_op; i < p->length; i++)
    for(j = 0; j < p->sta_op; j++) write[i][j] = value;
}

void Zero_weight_matrix(Machine_type *p, Tools_type **write) {
  bzero((char*) *write, Sizeof_weight_matrix(p));
}

/*
** copy a weight matrix from one location to another, taking into account
** a possible difference in the number of hidden units and i/o state units
*/

void Copy_weight_matrix(Machine_type *p, Tools_type **read,
			Machine_type *q, Tools_type **write) {
  int i, j;

  for(i = q->hidden, j = p->hidden; i < q->sta_op && j < p->sta_op; i++, j++) {
    int min0 = q->hidden < p->hidden ? q->hidden : p->hidden;
    int min1 = i - q->hidden < j - p->hidden ? i - q->hidden : j - p->hidden;
    COPY(read[j], write[i], min0);
    COPY(read[j] + p->hidden, write[i] + q->hidden, min1);
  }

  for(i = q->sta_op, j = p->sta_op; i < q->ext_op && j < p->ext_op; i++, j++) {
    int min0 = q->hidden < p->hidden ? q->hidden : p->hidden;
    int min1 = q->sta_op - q->hidden < p->sta_op - p->hidden ? 
               q->sta_op - q->hidden : p->sta_op - p->hidden;
    COPY(read[j], write[i], min0);
    COPY(read[j] + p->hidden, write[i] + q->hidden, min1);
  }

  for(i = q->ext_op, j = p->ext_op; i < q->length && j < p->length; i++, j++) {
    int min0 = q->hidden < p->hidden ? q->hidden : p->hidden;
    int min1 = q->sta_op - q->hidden < p->sta_op - p->hidden ? 
               q->sta_op - q->hidden : p->sta_op - p->hidden;
    COPY(read[j], write[i], min0);
    COPY(read[j] + p->hidden, write[i] + q->hidden, min1);
  }
}
