;;***************
;; LOCAL-COMMAND-PROCESSOR
;; -- input/output interface for processing commands.
;; -- handles the input and output commands within local machine

(defvar *data-file-name* nil)
(defvar *command-stream* nil)

;; MAKE-COMMAND-PROCESSOR
;; -- open the local data filename and return the input
;; -- and output functions
;;
(defun make-command-processor ()
  (open-local-file)
  (list #'input-func #'output-func))


;; OPEN-LOCAL-FILE
;; -- prompts user of the data file name and checks if it
;; -- is legal and open it if so
;;
(defun open-local-file ()
  (format t "Enter Data Filename to be processed : ")
  (setf *data-file-name* (read))
  (format t "We've got ~a .~%Type Y if correct, N if incorrect or quit to exit : " *data-file-name* )
  (let ((answer (read)))
    (cond  ((eq 'Y answer) 
	    (format t "PROCESSING START~%")
	    (setf *command-stream* 
		  (open (string-downcase *data-file-name*) :direction :input)))
	   ((eq 'quit answer)
	    (error "PROCESS TERMINATES~%"))
	   (t
	    (format t "TRY AGAIN~%")
	    (open-local-file)))))

;; INPUT-FUNC
;; -- reads from the command-stream 
;;
(defun input-func ()
  (let ((next-line (read *command-stream* nil)))
    (cond ((null next-line)
	   (close *command-stream*)
	   'nil)
	  (t 
	   next-line))))

;; OUTPUT-FUNC
;; -- just prints out the result back to local lisp interface
;;
(defun output-func (return-list)
  (format t "return-status: ~a~%return value: ~a~%sensor-data: ~a~%"
	  (car return-list)
	  (cadr return-list)
	  (caddr return-list)))









