;************************************************************************
;  ICON.LISP
;************************************************************************
; Code to display in a small icon some object that responds to unique-id
; and kind-id.   We display the kind-id abbreviation on one line, and 
; the unique-id on another.

(defconstant *icon-abbrevs*
             '((fuel-drum "DRUM")
               (mud-tires "M-TIRE")
               (enemy-unit "SCUM")
               (cow "COW")
               (cow-tool "COWBAG")
               (robot-truck "TRUCK")
               (standard-tires "S-TIRE")
               (gun "GUN")
               (box "BOX")
               (rock-machine "ROCK-M")
               (gun-tool "G-TOOL")
               (ammo-box "A-BOX")))

(defun icon-abbrev-string (sym)
  (let ((abbrev (assoc sym *icon-abbrevs* :test #'eq)))
    (if (null abbrev) 
		"THING"
		(cadr abbrev))))

;**************************************************************************

(defmethod disp-in-small-icon (thing position)
  (let* ((abbrev (icon-abbrev-string (kind-id thing)))
         (title (copy-seq (symbol-name (unique-id thing)))))
    (disp.with-origin position
     (disp.draw-rectangle (make-window 0 0  *small-icon-width* *small-icon-height*))
     (disp.with-font (disp.tiny-font) 
       (disp.center-text abbrev 
						 (make-position (truncate *small-icon-width* 2) 10))
	   (disp.center-text title  
						 (make-position (truncate *small-icon-width* 2) 25))))))

