(comment (herald enemy))

; --------------------------------------------------------------------
; * ENEMY-UNITS for simulating bad guys *
; ---------------------------------------
;
; Things defined in this file:
;  (UPDATE-ENEMY-UNITS-HERE self number time last-number last-time)
;  The enemy unit object pool
;
; Object builders:
;  
; This file makes reference to things in
;                                        OPERATIONS.T
;                                        LOWLEVEL.T
;                                        GLOBAL_DEFS.T

; See also HANDLER-DEFS HANDLERS ENEMY-UNIT-DEFS
;
; ------------------------------------------------------------------------------
; * Definitions for ENEMY-TROOPS *
; --------------------------------
;
; Enemy troops are treated in an unusual way by the simulator; they
;  are like weather.  The toplevel world object keeps track of the
;  (ENEMY-ACTIVITY ...) in each sector and whenever a truck is
;  present at a node enemy units might show up.  Similarly, whenever
;  a truck is moving down a link it may run into enemy units and
;  be forced to stop (treated like a mishap).
;
; Each time that a node updates itself, it can change the number of
;  enemy units on hand by calling the (UPDATE-ENEMY-UNITS-HERE ...)
;  procedure below.  Enemy units left over from before the truck
;  arrived are discounted and new units may be added.
;
; When enemy units are present at a node they try and CAPTURE any
;  trucks that are there.  This is accomplished through their
;  (UPDATE ...) function.
;
; Enemy units are stored in a pool so that they can be recycled 
;  easily.  The pool constructors are defined below.


(defun si.make-enemy-unit ()
  (let ((enemy (obtain-from-pool *si.enemy-unit-pool*)))
    (setf (recycle-pool enemy) *si.enemy-unit-pool*)
    enemy))

(defun enemy-unit-builder ()
  (make-instance 'enemy-unit
                 :id (make-unique-id 'scum)))

(defvar *si.enemy-unit-pool*
        (make-pool "Enemy-Unit-Pool" #'enemy-unit-builder))

(defun si.make-enemy-unit-handler ()
  (make-instance 'enemy-unit-handler
                 :id (make-unique-id 'scum-handler)))
  
(si.add-global-map-node-handler 'enemy-unit
                                #'si.make-enemy-unit-handler)
