;;; Note that when the documentation refers to operations,
;;; everything is now implemented in CLOS classes, instances
;;; and generic functions

;;; Everything that was a PACKAGE is now a PARCEL because of 
;;; conflicts in common lisp

;;; check printing etc

; --------------------------------------------------------------------
; ** Simulator support for LIQUIDS
; ----------------------------------------------------------
;
; Things defined in this file:
;
; Functions:
;  (SI:DECLARE-LIQUID kind classes) => void
;
; Object builders:
;
; This file makes reference to things in OPERATIONS LISP
;                                        LOWLEVEL.T
; --------------------------------------------------------------------
; ** Simulator support for THINGOID CONTAINERS
; --------------------------------------------
; THINGOIDS can be put in CONTAINERS.  A CONTAINER is a thingoid that
;  can hold other thingoids and a generic container is a thingoid 
;  itself.  When a thingoid is inside a container it is invisible to
;  all other objects in the simulation unless it is of a class for
;  which the container is invisible.  Examples of such classes are
;  paper containers and radioactive thingoids.
; CONTAINERS can be placed inside other containers but not VESSELS.
; Both CONTAINERS and VESSELS are parcelS
; --------------------------------------------------------------------
; ** Simulator support for liquids
; --------------------------------
; Liquids are handled by the simulator in a slightly different way
;  than solid objects.  First of all, a liquid cannot exist without
;  a vessel to put it in.  Second, a liquid cannot be poured into a
;  vessel if that vessel already holds some other type of liquid, or
;  if the vessel is full.  In other words, liquids cannot mix or
;  spill.  However, liquids can have properties (ie. classes) like
;  being radioactive or flammable.  Therefore, liquid types must be
;  defined in advance.  Also, vessels take on the additional
;  properties of the liquids that they hold.
; Liquids can only be placed in VESSELS not in any other kind of
;  container.  Similarily, nothing but a liquid can be put in a
;  vessel.
; LIQUID properties are kept as an alist and are referenced through
;  the following function:
;
; (SI:DECLARE-LIQUID kind classes) => void
;  -    kind: A globally unique name for the liquid.
;  - classes: A list of classes that the liquid belongs to.
;
; (GET-LIQUID-CLASSES kind) => the classes of liquid kind.
; (DECLARED-LIQUID? kind)   => boolean

(let ((liquid-properties nil))
  
  (defun si.declare-liquid (liquid-type classes)
    (setf liquid-properties
          (cons (list liquid-type classes)
                (delete liquid-type
                        liquid-properties
                        :test
                        #'(lambda (x y) (eq x (car y))))))
    t)

  (defun get-liquid-classes (liquid-type)
    (cadr (assoc liquid-type liquid-properties :test #'eq)))
  
  (defun declared-liquid? (liquid-type)
    (or (eq liquid-type 'undefined-liquid)
        (assoc liquid-type liquid-properties :test #'eq))))
