(comment (herald support))

; ------------------------------------------------------------------------------
; * Definitions for truck support objects *
; -----------------------------------------

; -------------------------------------------------------------------
; * Definitions for WEAPONS *
; ---------------------------


(defclass weapon   
  (vessel container)
  ((effectiveness :accessor effectiveness
                  :initarg :effectiveness)
   (shots-per-turn :accessor shots-per-turn
                   :initarg :shots-per-turn)
   ))

;;; ** Special WEAPON type operations

(defmethod toggle ((self weapon))
  (let ((ammo-left (if (eq (liquid-held self) 'ammo)
                     (space-full self)
                     0)))
    (cond ((> ammo-left 0)
           (let* ((enemy (get-if-visible-class (environment self)
                                               'enemy-unit)) 
                  (shots (min (effectiveness self)  ammo-left)))
             (cond ((and enemy (> shots 0))
                    (do ((shots-to-go shots
                                      (- shots-to-go 1)))
                        ((or (<= shots-to-go 0)
                             (null enemy))
                         t)
                      (pour-out self 1)
                      (if (displayer self)
                        (dm-speak (displayer self)
                                  '(prompt bang)))
                      (cond ((random-chance? (effectiveness self))
                             (take-out (environment (car enemy))
                                       (car enemy))
                             (recycle (car enemy))
                             (setf enemy (cdr enemy))))))
                   (t nil))))
          (t nil))))

(Defmethod examine ((self weapon))
  (post-sensor-datum 'shots-left
                     (id self)
                     (space-full self)
                     nil
                     nil))


