(comment (herald trucks))

; --------------------------------------------------------------------
; ** Objects of type TRUCK **
; ---------------------------
; This file contains definitions for:
;
; Operations:
; Object constructors
; This file makes use of things in - BASIC.T
;                                    THINGOIDS.T
;                                    CONTAINERS.T
;                                    ARMS.T
; --------------------------------------------------------------------
; * Special TRUCK type operations *
; ---------------------------------
; ERRORS: TRUCK-CANT-MOVE, TRUCK-MISHAP, EYE-CANT-FIND
; --------------------------------------------------------------------
; * Generic TRUCK object constructor *
; ------------------------------------

(defun si.make-truck-generic (id kind
                                 arms
                                 bays
                                 fuel-bay
                                 tire-bay
                                 weapon-bay
                                 base-speed
                                 base-fuel-consumption
                                 visibles)
  (let ((new-thing (make-instance 'truck
                                  :id id
                                  :kind kind
                                  :arms arms
                                  :bays bays
                                  :fuel-bay fuel-bay
                                  :tire-bay tire-bay
                                  :weapon-bay weapon-bay
                                  :base-speed base-speed
                                  :base-fuel-consumption base-fuel-consumption
                                  :visibles visibles)))
    (if (symbolp kind)
      (setf (kind new-thing) (list kind)))
    (setf (holdings new-thing)
          (append (arms new-thing) 
                  (bays new-thing) 
                  (list weapon-bay tire-bay fuel-bay)))
    (mapcar #'(lambda (x) (setf (environment x) new-thing)) (bays new-thing))
    (mapcar #'(lambda (x) (setf (arm-anchor x) new-thing)) (arms new-thing))
    (setf (environment (fuel-bay new-thing)) new-thing)
    (setf (environment (tire-bay new-thing)) new-thing)
    (setf (environment (weapon-bay new-thing)) new-thing)
    new-thing))

