;********************************************************************
;  SIMPLE-WORLD.LISP
;    By running the function start-the-world you will 
;    create a world with 10 locations and several objects,
;    as well as initializing the simulator using that world.

;***************************************************************** 

  ;  List of map locations
(defvar *location-list*)

  ;  Map roads
(defvar *road-list*)

  ;  The truck object, passed in to the simulator
(defvar	*the-truck*)

  ;  This object just packages up the locations and roads.
  ;  Generated by create-world and passed into make-displayer
(defvar	*the-world*)

  ;  This object is the interface between you and the simulated
  ;  world itself.  Each simulator action gives rise to a change
  ;  in display, which is passed as a message to the displayer object.
(defvar	*the-displayer*)

(defvar n1) (defvar n2) (defvar n3) (defvar n4) (defvar n5)
(defvar n6) (defvar n7) (defvar n8) (defvar n9) (defvar n10)

;**************************************************************************
;  The history list.  This determines (probabilistically) where and 
;  when exogenous events (rainstorms and enemy troop movements) will 
;  occur.  Syntax is incredibly obscure, and should be improved.  Refer
;  to the full manual for details, or use this one, or just make it null.

(defun create-history ()
  (setf *history-list*
        '(((0 0 0) (weather 1 sunny) (enemy-activity 1 15))
          ((0 0 0) (weather 2 sunny) (enemy-activity 2 15))
          ((0 0 0) (weather 3 sunny) (enemy-activity 3 0))
          ((0 0 0) (weather 4 sunny) (enemy-activity 4 15))
          ((0 5 0) (weather 2 rainy) (weather 3 rainy) (weather 1 cloudy))
          ((0 10 0) (enemy-activity 1 60))
          ((1 0 0) (day-time 1 night))
          ((1 5 0) (weather 3 sunny) (weather 1 cloudy) (weather 4 rainy))
          ((1 10 0) (enemy-activity 2 60)))))

;*****************************************************************************
;  Create locations.  All we really need is a name, the associated map sector
;  and a window (relative to the map subwindow) where this node is to be 
;  displayed.

(defun create-locations ()
  (setf n1 (make-location 'battle 1 (make-window 25 25 75 50)))
  (setf n2 (make-location 'demand-2 1 (make-window 225 50 75 50)))
  (setf n3 (make-location 'intersection 1 (make-window 100 125 20 20)))
           ; Sector 2
  (setf n4 (make-location 'demand-1 2 (make-window 400 25 75 50)))
  (setf n5 (make-location 'fuel-depot 2 (make-window 320 100 65 35)))
  (setf n6 (make-location 'intersection 2 (make-window 390 150 20 20)))
           ; Sector 3
  (setf n7 (make-location 'intersection 3 (make-window 100 165 20 20)))
  (setf n8 (make-location 'main-whs 3 (make-window 50 225 75 50)))
           ; Sector 4
  (setf n9 (make-location 'maint-1 4 (make-window 425 225 50 50)))
  (setf n10 (make-location 'intersection 4 (make-window 390 190 20 20)))

  (setf *location-list* (list n1 n2 n3 n4 n5 n6 n7 n8 n9 n10)))

;*****************************************************************************
;  Create the roads.  Arguments are 
;   -  road type (can be a list of properties the road exhibits)
;   -  starting location (a location)
;   -  starting direction (the direction you have to be headed if you're
;         at the starting location and want to travel on this road)
;   -  ending node, ending location (ditto)
;   -  length of road 
;   -  general direction of road (can't remember why this is significant!)
;   -  "fragility"  how big can a truck be to drive over the road without
;      breaking it
;   -  sector (what map sector is the road in)
;   -  display point.  a hint to the displayer as to an intermediate point
;       that the line displaying the road should pass through.  nil means 
;       the road will connect its start and end nodes using a direct line.

(defun create-roads ()
  (setf l1 (make-road 'standard-road n3 'n n1 's 20 'n nil 1 nil))
  (setf l2 (make-road 'standard-road n2 'nw n1 'se 20 'nw nil 1 nil))
  (setf l3 (make-road 'soft-road  n3 'ne n2 'sw 20 'ne nil 1 nil))
      ; Sector 2
  (setf l4 (make-road '(winding-road windy) n5 'ne n4 'sw 15 'ne nil 2 nil))
  (setf l5 (make-road 'express-road n6 'n n4 's 20 'n nil 2  nil))
  (setf l6 (make-road 'standard-road n6 'nw n5 'se 10 'nw nil 2 nil))
  (setf l7 (make-road '(bumpy-road bumpy) n3 'e n6 'w 20 'e nil 2 nil))
  (setf l8 (make-road '(muddy-road muddy) n2 'e n5 'w 15 'e nil 2 nil))
     ; Sector 3
  (setf l9 (make-road 'standard-road n8 'n n7 'sw 5 'n nil 3 nil))
  (setf l10 (make-road 'standard-road n8 'ne n10 'sw 25 'e nil 3 nil))
     ; Sector 4
  (setf l11 (make-road 'standard-road n9 'nw n10 'se 2 'n nil 4 nil))
     ; Bridges
  (setf l12 (make-road 'bridge n7 'n n3 's 1 'n nil 3 nil))
  (setf l13 (make-road 'bridge n10 'n n6 's 1 'n  nil 4 nil))

  (setf *road-list* (list l1 l2 l3 l4 l5 l6 l7 l8 l9 l10 l11 l12 l13)))

;***************************************************************************
; Create the world by creating its history, locations, and roads, and just
; packaging them up.

(defun create-world ()
  (create-history)
  (create-locations)
  (create-roads)
  (setf *the-world* 
		(make-world 'world 4 *history-list* *location-list* *road-list*)))

;*******************************************************************************
; Creating the truck.  
;   Bays:  first argument is name, second is capacity, third is obscure (see
;     manual).
;   Arms:  first three arguments same as bays, third is "clumsiness" (percent
;     of time that a grasp operation will fail).
;   Truck:  name, arms bays, speed (mph at medium speed), fuel efficiency
;     (mpg at medium speed), "visibles" (same obscure argument.  always seems
;     to be nil.)

(defun create-truck ()
  (let ((bay1 (si.make-cargo-bay 'bay1 20 nil))
		(bay2 (si.make-cargo-bay 'bay2 100 nil))
		(arm1 (si.make-robot-arm 'arm1 8 nil 0))
		(arm2 (si.make-robot-arm 'arm2 15 nil 50)))
	(setf *the-truck*
		  (si.make-standard-truck 'van-1 (list arm1 arm2) (list bay1 bay2)
			                      30 45 15 nil))))

;****************************************************************************
;  Populate the world by "putting-in" things into locations.
;  Note that we situate the truck by putting it in somewhere too.
;

(defun populate-world ()
  (put-in (nth 7 *location-list*) *the-truck*)

  (put-in (nth 0 *location-list*) (si.make-enemy-unit))
  (put-in (nth 0 *location-list*) (si.make-enemy-unit))

  (put-in (nth 7 *location-list*) (make-full-fuel-drum 5))
  (put-in (nth 7 *location-list*) (make-full-fuel-drum 5))
  (put-in (nth 7 *location-list*)
		  (make-standard-weapon 'gun-1 'gun 15 *si.weapon-size* '(gun-tool) 60 3))
  (put-in (nth 7 *location-list*) (make-standard-item 'tool-2 'gun-tool 4 nil))
  (put-in (nth 7 *location-list*) (make-full-ammo-box 15))
  (put-in (nth 7 *location-list*) (make-full-ammo-box 15))
  
  (put-in (nth 8 *location-list*) (make-tires 'mud-tires))
  (put-in (nth 8 *location-list*) (make-full-ammo-box 15))

  (put-in (nth 4 *location-list*) (make-full-fuel-drum 5))
  (put-in (nth 4 *location-list*) (make-full-fuel-drum 5))
  (put-in (nth 4 *location-list*) (make-full-fuel-drum 5))
  (put-in (nth 4 *location-list*) (make-full-fuel-drum 5))
  (put-in (nth 4 *location-list*) (make-full-fuel-drum 5))
  (put-in (nth 4 *location-list*) (make-full-fuel-drum 5))

  (put-in (nth 0 *location-list*) (make-standard-item 'tool-1 'rock-tool 4 nil))
  (put-in (nth 0 *location-list*) (si.make-generic-rock nil 10 '(rock-tool) 40))
  (put-in (nth 0 *location-list*) (si.make-generic-rock nil 10 '(rock-tool) 70))
  (put-in (nth 0 *location-list*) (si.make-rock-machine 'maker))
  (put-in (nth 0 *location-list*) (si.make-box 'box-0)))

;******************************************************************************
;  Just call the functions from above, but also note the call to 
;  make-displayer.    Then in the last line we connect up the truck 
;  (which is part of the simulated world) with the displayer (which is 
;  part of the graphic display module.

(defun start-the-world (&optional (displayer-string ""))
  (create-world)
  (create-truck)
  (populate-world)
  (setf *the-displayer* 
		(make-displayer *the-truck* *the-world* 0 0 displayer-string))
  (setf (displayer *the-truck*) *the-displayer*))


(defun run-the-world ()
  (run-simulator *the-truck* *the-world*))