/*
    num_rand.c  -- Random numbers.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"
#include "num_include.h"

object
rando(object x, object rs)
{
	enum type tx;
	object z;
	double d;
	
	tx = type_of(x);
	if (number_compare(x, MAKE_FIXNUM(0)) != 1)
		FEwrong_type_argument(TSpositive_number, x);
	d = (double)(rs->rnd.rnd_value>>1) / (4294967296.0/2.0);
	d = number_to_double(x) * d;
	if (tx == t_fixnum) {
		z = MAKE_FIXNUM((int)d);
		return(z);
	} else if (tx == t_bignum) {
		z = double_to_integer(d);
		return(z);
	} else if (tx == t_shortfloat) {
		z = alloc_object(t_shortfloat);
		sf(z) = (float)d;
		return(z);
	} else if (tx == t_longfloat) {
		z = alloc_object(t_longfloat);
		lf(z) = d;
		return(z);
	} else
		FEerror("~S is not an integer nor a floating-point number.",
			1, x);
}

object
make_random_state(object rs)
{
        object z;

	if (Null(rs)) {
		z = alloc_object(t_random);
		z->rnd.rnd_value = symbol_value(Vrandom_state)->rnd.rnd_value;
		return(z);
	} else if (rs == Ct) {
		z = alloc_object(t_random);
#ifdef unix
		z->rnd.rnd_value = time(0);
#endif
		return(z);
	} else if (type_of(rs) != t_random)
   		FEwrong_type_argument(Srandom_state, rs);
	else {
		z =alloc_object(t_random);
		z->rnd.rnd_value = rs->rnd.rnd_value;
		return(z);
	}
}

advance_random_state(object rs)
{
	rs->rnd.rnd_value
	= rs->rnd.rnd_value
	+ (rs->rnd.rnd_value<<2)
	+ (rs->rnd.rnd_value<<17)
	+ (rs->rnd.rnd_value<<27);
}


Lrandom(int narg, object x, object y)
{
	object rs;
	
	if (narg < 1) FEtoo_few_arguments(&narg);
	if (narg > 2) FEtoo_many_arguments(&narg);
	if (narg == 1)
		rs = symbol_value(Vrandom_state);
	else
	  rs = y;
	check_type_random_state(&rs);
	advance_random_state(rs);
	VALUES(0) = rando(x, rs);
	RETURN(1);
}

Lmake_random_state(int narg, object x)
{
	int j;
	object rs;

	if (narg > 1) FEtoo_many_arguments(&narg);
	if (narg == 0)
		rs = Cnil;
	else
	  rs = x;
	VALUES(0) = make_random_state(rs);
	RETURN(1);
}

Lrandom_state_p(int narg, object x)
{
	check_arg(1);
	VALUES(0) = (type_of(x) == t_random) ? Ct : Cnil;
	RETURN(1);
}

init_num_rand()
{
        Vrandom_state = make_special("*RANDOM-STATE*",
				     make_random_state(Ct));

	make_function("RANDOM", Lrandom);
	make_function("MAKE-RANDOM-STATE", Lmake_random_state);
	make_function("RANDOM-STATE-P", Lrandom_state_p);
}
