/*
    typespec.c -- Type specifier routines.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/


#include "config.h"

/******************************* EXPORTS ******************************/

object
St,		Snil,		Scommon,	Ssequence,
Snull,		Scons,		Slist,		Ssymbol,
Sarray,		Svector,	Sbit_vector,	Sstring,
Ssimple_array,	Ssimple_vector,	Ssimple_string,	Ssimple_bit_vector,
Sfunction,	Spathname,	Scharacter,	Scompiled_function,
Snumber,	Srational,	Sfloat,		Sstring_char,
Sinteger,	Sratio,		Sshort_float,	Sstandard_char,
Sfixnum,	Scomplex,	Ssingle_float,	Spackage,
Sbignum,	Srandom_state,	Sdouble_float,	Sstream,
Sbit,		Sreadtable,	Slong_float,	Shash_table,
Ssigned_char,	Sunsigned_char,	Ssigned_short,	Sunsigned_short;

#ifdef MTCL
object Scont, Sthread;
#endif MTCL

#ifdef CLOS
object Sinstance, Sdispatch_function;
#endif

#ifdef LOCATIVE
object Slocative;
#endif

object Sstructure,	Ssatisfies,	Smember,	Snot,	Sor,	Sand;
object Svalues,	Smod,	Ssigned_byte,	Sunsigned_byte;

object SA;		/*  symbol *  */
object Splusp;

object TSor_symbol_string;
object TSor_string_symbol;
object TSor_symbol_string_package;

object TSnon_negative_integer;
object TSpositive_number;
object TSor_integer_float;
object TSor_rational_float;

#ifdef unix
object TSor_pathname_string_symbol;
#endif
object TSor_pathname_string_symbol_stream;

/******************************* ------- ******************************/

object Skeyword;

check_type_integer(object *p)
{
	enum type t;

	while ((t = type_of(*p)) != t_fixnum && t != t_bignum)
		*p = wrong_type_argument(Sinteger, *p);
}

check_type_non_negative_integer(object *p)
{
	enum type t;

	for (;;) {
		t = type_of(*p);
		if (t == t_fixnum) {
			if (fix((*p)) >= 0)
				break;
		} else if (t == t_bignum) {
			if (big_sign((struct bignum *)(*p)) >= 0)
				break;
		}
		*p = wrong_type_argument(TSnon_negative_integer, *p);
	}
}

check_type_rational(object *p)
{
	enum type t;

	while ((t = type_of(*p)) != t_fixnum &&
	       t != t_bignum && t != t_ratio)
		*p = wrong_type_argument(Srational, *p);
}

check_type_float(object *p)
{
	enum type t;

	while ((t = type_of(*p)) != t_shortfloat && t != t_longfloat)
		*p = wrong_type_argument(Sfloat, *p);
}

check_type_or_integer_float(object *p)
{
	enum type t;

	while ((t = type_of(*p)) != t_fixnum && t != t_bignum &&
	       t != t_shortfloat && t != t_longfloat)
		*p = wrong_type_argument(TSor_integer_float, *p);
}

check_type_or_rational_float(object *p)
{
	enum type t;

	while ((t = type_of(*p)) != t_fixnum && t != t_bignum &&
	       t != t_ratio && t != t_shortfloat && t != t_longfloat)
		*p = wrong_type_argument(TSor_rational_float, *p);
}

check_type_number(object *p)
{
	enum type t;

	while ((t = type_of(*p)) != t_fixnum && t != t_bignum &&
	       t != t_ratio && t != t_shortfloat && t != t_longfloat &&
	       t != t_complex)
		*p = wrong_type_argument(Snumber, *p);
}

check_type_bit(object *p)
{
	while (!FIXNUMP(*p) ||
	       fix((*p)) != 0 && fix((*p)) != 1)
		*p = wrong_type_argument(Sbit, *p);
}

check_type_character(object *p)
{
	while (type_of(*p) != t_character)
		*p = wrong_type_argument(Scharacter, *p);
}

check_type_string_char(object *p)
{
	while (type_of(*p) != t_character ||
	       char_font((*p)) != 0 ||
	       char_bits((*p)) != 0)
		*p = wrong_type_argument(Scharacter, *p);
}

check_type_symbol(object *p)
{
	while (type_of(*p) != t_symbol)
		*p = wrong_type_argument(Ssymbol, *p);
}

check_type_or_symbol_string(object *p)
{
	while (type_of(*p) != t_symbol && type_of(*p) != t_string)
		*p = wrong_type_argument(TSor_symbol_string, *p);
}

check_type_or_string_symbol(object *p)
{
	while (type_of(*p) != t_symbol && type_of(*p) != t_string)
		*p = wrong_type_argument(TSor_string_symbol, *p);
}

check_type_or_symbol_string_package(object *p)
{
	while (type_of(*p) != t_symbol &&
	       type_of(*p) != t_string &&
	       type_of(*p) != t_package)
		*p = wrong_type_argument(TSor_symbol_string_package,
 					   *p);
}

check_type_package(object *p)
{
	while (type_of(*p) != t_package)
		*p = wrong_type_argument(Spackage, *p);
}

check_type_string(object *p)
{
	while (type_of(*p) != t_string)
		*p = wrong_type_argument(Sstring, *p);
}

check_type_bit_vector(object *p)
{
	while (type_of(*p) != t_bitvector)
		*p = wrong_type_argument(Sbit_vector, *p);
}

check_type_cons(object *p)
{
	while (type_of(*p) != t_cons)
		*p = wrong_type_argument(Scons, *p);
}

check_type_stream(object *p)
{
	while (type_of(*p) != t_stream)
		*p = wrong_type_argument(Sstream, *p);
}

check_type_readtable(object *p)
{
	while (type_of(*p) != t_readtable)
		*p = wrong_type_argument(Sreadtable, *p);
}

#ifdef unix
check_type_or_Pathname_string_symbol(object *p)
{
	enum type t;

	while ((t = type_of(*p)) != t_pathname &&
	       t != t_string && t != t_symbol)
		*p = wrong_type_argument(
			TSor_pathname_string_symbol, *p);
}
#endif

check_type_or_pathname_string_symbol_stream(object *p)
{
	enum type t;

	while ((t = type_of(*p)) != t_pathname &&
	       t != t_string && t != t_symbol && t != t_stream)
		*p = wrong_type_argument(
			TSor_pathname_string_symbol_stream, *p);
}

check_type_random_state(object *p)
{
	while (type_of(*p) != t_random)
		*p = wrong_type_argument(Srandom_state, *p);
}

check_type_hash_table(object *p)
{
	while (type_of(*p) != t_hashtable)
		*p = wrong_type_argument(Shash_table, *p);
}

check_type_array(object *p)
{
BEGIN:
	switch (type_of(*p)) {
	case t_array:
	case t_vector:
	case t_string:
	case t_bitvector:
		return;

	default:
		*p = wrong_type_argument(Sarray, *p);
		goto BEGIN;
	}
}

check_type_vector(object *p)
{
BEGIN:
	switch (type_of(*p)) {
	case t_vector:
	case t_string:
	case t_bitvector:
		return;

	default:
		*p = wrong_type_argument(Svector, *p);
		goto BEGIN;
	}
}

object
TYPE_OF(object x)
{
	switch (type_of(x)) {
#ifdef CLOS
        case t_instance:
		{ object cl = CLASS_OF(x);
		  if (CLASS_NAME(cl) != Cnil)
		    return(CLASS_NAME(cl));
		  else
		    return(cl);
		}
#endif

	case t_fixnum:
		return(Sfixnum);

	case t_bignum:
		return(Sbignum);

	case t_ratio:
		return(Sratio);

	case t_shortfloat:
		return(Sshort_float);

	case t_longfloat:
		return(Slong_float);

	case t_complex:
		return(Scomplex);

	case t_character:
		if (char_font(x) != 0
		 || char_bits(x) != 0)
			return(Scharacter);
		else { int i = char_code(x);
			if (' ' <= i && i < '\177' || i == '\n')
				return(Sstandard_char);
			else
				return(Sstring_char);
		}

	case t_symbol:
		if (x->s.s_hpack == keyword_package)
			return(Skeyword);
		else
			return(Ssymbol);

	case t_package:
		return(Spackage);

	case t_cons:
		return(Scons);

	case t_hashtable:
		return(Shash_table);

	case t_array:
		if (x->a.a_adjustable ||
		    Null(CAR(x->a.a_displaced)))
			return(Sarray);
		else
			return(Ssimple_array);

	case t_vector:
		if (x->v.v_adjustable ||
		    x->v.v_hasfillp ||
		    Null(CAR(x->v.v_displaced)) ||
		    (enum aelttype)x->v.v_elttype != aet_object)
			return(Svector);
		else
			return(Ssimple_vector);

	case t_string:
		if (x->st.st_adjustable ||
		    x->st.st_hasfillp ||
		    Null(CAR(x->st.st_displaced)))
			return(Sstring);
		else
			return(Ssimple_string);

	case t_bitvector:
		if (x->bv.bv_adjustable ||
		    x->bv.bv_hasfillp ||
		    Null(CAR(x->bv.bv_displaced)))
			return(Sbit_vector);
		else
			return(Ssimple_bit_vector);

#ifndef CLOS
	case t_structure:
		return(x->str.str_name);
#endif CLOS

	case t_stream:
		return(Sstream);

	case t_readtable:
		return(Sreadtable);

	case t_pathname:
		return(Spathname);

	case t_random:
		return(Srandom_state);

	case t_cfun:
	case t_cclosure:
		return(Scompiled_function);

#ifdef MTCL
	case t_cont:
		return(Scont);

	case t_thread:
		return(Sthread);
#endif MTCL
#ifdef CLOS
	case t_gfun:
		return(Sdispatch_function);
#endif
#ifdef LOCATIVE
	      case t_locative:
		return(Slocative);
#endif

	default:
		error("not a lisp data object");
	}
}

Ltype_of(int narg, object x)
{
	check_arg(1);
        VALUES(0)=TYPE_OF(x);
	RETURN(1);
      }

init_typespec()
{
	Squote = make_ordinary("QUOTE");
	enter_mark_origin(&Squote);
	Sfunction = make_ordinary("FUNCTION");
	enter_mark_origin(&Sfunction);
	Slambda = make_ordinary("LAMBDA");
	enter_mark_origin(&Slambda);
	Slambda_block = make_ordinary("LAMBDA-BLOCK");
	enter_mark_origin(&Slambda_block);
	Slambda_closure = make_ordinary("LAMBDA-CLOSURE");
	enter_mark_origin(&Slambda_closure);
	Slambda_block_closure = make_ordinary("LAMBDA-BLOCK-CLOSURE");
	enter_mark_origin(&Slambda_block_closure);
	Sspecial = make_ordinary("SPECIAL");
	enter_mark_origin(&Sspecial);

	St = make_ordinary("T");
	enter_mark_origin(&St);
	Snil = make_ordinary("NIL");
	enter_mark_origin(&Snil);
	Scommon = make_ordinary("COMMON");
	enter_mark_origin(&Scommon);
	Snull = make_ordinary("NULL");
	enter_mark_origin(&Snull);
	Scons = make_ordinary("CONS");
	enter_mark_origin(&Scons);
	Slist = make_ordinary("LIST");
	enter_mark_origin(&Slist);
	Ssymbol = make_ordinary("SYMBOL");
	enter_mark_origin(&Ssymbol);
	Sarray = make_ordinary("ARRAY");
	enter_mark_origin(&Sarray);
	Svector = make_ordinary("VECTOR");
	enter_mark_origin(&Svector);
	Sbit_vector = make_ordinary("BIT-VECTOR");
	enter_mark_origin(&Sbit_vector);
	Sstring = make_ordinary("STRING");
	enter_mark_origin(&Sstring);
	Ssequence = make_ordinary("SEQUENCE");
	enter_mark_origin(&Ssequence);
	Ssimple_array = make_ordinary("SIMPLE-ARRAY");
	enter_mark_origin(&Ssimple_array);
	Ssimple_vector = make_ordinary("SIMPLE-VECTOR");
	enter_mark_origin(&Ssimple_vector);
	Ssimple_bit_vector = make_ordinary("SIMPLE-BIT-VECTOR");
	enter_mark_origin(&Ssimple_bit_vector);
	Ssimple_string = make_ordinary("SIMPLE-STRING");
	enter_mark_origin(&Ssimple_string);
	Sfunction = make_ordinary("FUNCTION");
	enter_mark_origin(&Sfunction);
	Scompiled_function = make_ordinary("COMPILED-FUNCTION");
	enter_mark_origin(&Scompiled_function);
	Spathname = make_ordinary("PATHNAME");
	enter_mark_origin(&Spathname);
	Scharacter = make_ordinary("CHARACTER");
	enter_mark_origin(&Scharacter);
	Snumber = make_ordinary("NUMBER");
	enter_mark_origin(&Snumber);
	Srational = make_ordinary("RATIONAL");
	enter_mark_origin(&Srational);
	Sfloat = make_ordinary("FLOAT");
	enter_mark_origin(&Sfloat);
	Sstring_char = make_ordinary("STRING-CHAR");
	enter_mark_origin(&Sstring_char);
	Sinteger = make_ordinary("INTEGER");
	enter_mark_origin(&Sinteger);
	Sratio = make_ordinary("RATIO");
	enter_mark_origin(&Sratio);
	Sshort_float = make_ordinary("SHORT-FLOAT");
	enter_mark_origin(&Sshort_float);
	Sstandard_char = make_ordinary("STANDARD-CHAR");
	enter_mark_origin(&Sstandard_char);
	Sfixnum = make_ordinary("FIXNUM");
	enter_mark_origin(&Sfixnum);
	Scomplex = make_ordinary("COMPLEX");
	enter_mark_origin(&Scomplex);
	Ssingle_float = make_ordinary("SINGLE-FLOAT");
	enter_mark_origin(&Ssingle_float);
	Spackage = make_ordinary("PACKAGE");
	enter_mark_origin(&Spackage);
	Sbignum = make_ordinary("BIGNUM");
	enter_mark_origin(&Sbignum);
	Srandom_state = make_ordinary("RANDOM-STATE");
	enter_mark_origin(&Srandom_state);
	Sdouble_float = make_ordinary("DOUBLE-FLOAT");
	enter_mark_origin(&Sdouble_float);
	Sstream = make_ordinary("STREAM");
	enter_mark_origin(&Sstream);
	Sbit = make_ordinary("BIT");
	enter_mark_origin(&Sbit);
	Sreadtable = make_ordinary("READTABLE");
	enter_mark_origin(&Sreadtable);
	Slong_float = make_ordinary("LONG-FLOAT");
	enter_mark_origin(&Slong_float);
	Shash_table = make_ordinary("HASH-TABLE");
	enter_mark_origin(&Shash_table);
	
	Skeyword = make_ordinary("KEYWORD");
	enter_mark_origin(&Skeyword);

#ifndef CLOS
	Sstructure = make_ordinary("STRUCTURE");
	enter_mark_origin(&Sstructure);
#endif

	Ssatisfies = make_ordinary("SATISFIES");
	enter_mark_origin(&Ssatisfies);
	
	Smember = make_ordinary("MEMBER");
	enter_mark_origin(&Smember);
	Snot = make_ordinary("NOT");
	enter_mark_origin(&Snot);
	Sor = make_ordinary("OR");
	enter_mark_origin(&Sor);
	Sand = make_ordinary("AND");
	enter_mark_origin(&Sand);
	
	Svalues = make_ordinary("VALUES");
	enter_mark_origin(&Svalues);
	
	Smod = make_ordinary("MOD");
	enter_mark_origin(&Smod);
	Ssigned_byte = make_ordinary("SIGNED-BYTE");
	enter_mark_origin(&Ssigned_byte);
	Sunsigned_byte = make_ordinary("UNSIGNED-BYTE");
	enter_mark_origin(&Sunsigned_byte);
	Ssigned_char = make_ordinary("SIGNED-CHAR");
	enter_mark_origin(&Ssigned_char);
	Sunsigned_char = make_ordinary("UNSIGNED-CHAR");
	enter_mark_origin(&Sunsigned_char);
	Ssigned_short = make_ordinary("SIGNED-SHORT");
	enter_mark_origin(&Ssigned_short);
	Sunsigned_short = make_ordinary("UNSIGNED-SHORT");

	SA = make_ordinary("*");
	enter_mark_origin(&SA);
	Splusp = make_ordinary("PLUSP");
	enter_mark_origin(&Splusp);
#ifdef MTCL
	Scont = make_ordinary("CONT");
	enter_mark_origin(&Scont);
	Sthread = make_ordinary("THREAD");
	enter_mark_origin(&Sthread);
#endif MTCL
#ifdef CLOS
	Sinstance = make_ordinary("INSTANCE");
	enter_mark_origin(&Sinstance);
	Sdispatch_function = make_ordinary("DISPATCH-FUNCTION");
	enter_mark_origin(&Sdispatch_function);
#endif
#ifdef LOCATIVE
	Slocative = make_ordinary("LOCATIVE");
	enter_mark_origin(&Slocative);
#endif
}

init_typespec_function()
{
	TSor_symbol_string
	= CONS(Sor, CONS(Ssymbol, CONS(Sstring, Cnil)));
	enter_mark_origin(&TSor_symbol_string);
	TSor_string_symbol
	= CONS(Sor, CONS(Sstring, CONS(Ssymbol, Cnil)));
	enter_mark_origin(&TSor_string_symbol);
	TSor_symbol_string_package
	= CONS(Sor,
		    CONS(Ssymbol,
			      CONS(Sstring,
					CONS(Spackage, Cnil))));
	enter_mark_origin(&TSor_symbol_string_package);

	TSnon_negative_integer
	= CONS(Sinteger,
		    CONS(MAKE_FIXNUM(0), CONS(SA, Cnil)));
	enter_mark_origin(&TSnon_negative_integer);
	TSpositive_number = CONS(Ssatisfies, CONS(Splusp, Cnil));
	enter_mark_origin(&TSpositive_number);
	TSor_integer_float
	= CONS(Sor, CONS(Sinteger, CONS(Sfloat, Cnil)));
	enter_mark_origin(&TSor_integer_float);
	TSor_rational_float
	= CONS(Sor, CONS(Srational, CONS(Sfloat, Cnil)));
	enter_mark_origin(&TSor_rational_float);
#ifdef unix
	TSor_pathname_string_symbol
	= CONS(Sor,
		    CONS(Spathname,
			      CONS(Sstring,
					CONS(Ssymbol,
						  Cnil))));
	enter_mark_origin(&TSor_pathname_string_symbol);
#endif unix
	TSor_pathname_string_symbol_stream
	= CONS(Sor,
		    CONS(Spathname,
			      CONS(Sstring,
					CONS(Ssymbol,
						  CONS(Sstream,
							    Cnil)))));
	enter_mark_origin(&TSor_pathname_string_symbol_stream);

	make_function("TYPE-OF", Ltype_of);
}				
