/*
    Copyright (c) 1993, Giuseppe Attardi.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/

/*
	cmp/init_cmp.c
*/

#include <ecl.h>

extern object siVsystem_directory, Kerror;
extern object open_stream();

/* So that they are not placed before init_compiler */
extern char *data_file_name;
extern char *sysfun_file;

init_compiler(int size, object data)
{
	object data_file;

	Lmerge_pathnames(2, symbol_value(siVsystem_directory),
/* sgi command ld -r does not preserve defined symbols like 'data_file_name' */
#ifdef sgi
			 make_simple_string("compiler.data")
#else
			 make_simple_string(data_file_name)
#endif sgi
			 );
	data_file = open_stream(namestring(VALUES(0)),
				smm_input, Cnil, Kerror);
	init_cmpdefs(size, data_file);
	init_cmpinline(size, data_file);
	init_cmputil(size, data_file);
	init_cmptype(size, data_file);
	init_cmpbind(size, data_file);
	init_cmpblock(size, data_file);
	init_cmpcall(size, data_file);
	init_cmpcatch(size, data_file);
	init_cmpenv(size, data_file);
	init_cmpeval(size, data_file);
	init_cmpexit(size, data_file);
	init_cmpflet(size, data_file);
	init_cmpfun(size, data_file);
	init_cmpif(size, data_file);
	init_cmplam(size, data_file);
	init_cmplet(size, data_file);
	init_cmploc(size, data_file);
	init_cmpmap(size, data_file);
	init_cmpmulti(size, data_file);
	init_cmpspecial(size, data_file);
	init_cmptag(size, data_file);
	init_cmptop(size, data_file);
	init_cmpvar(size, data_file);
	init_cmpwt(size, data_file);
	init_cmpmain(size, data_file);
	close_stream(data_file, TRUE);
	Lmerge_pathnames(2, symbol_value(siVsystem_directory),
#ifdef sgi
			 make_simple_string("sysfun.lsp"));
 print(VALUES(0),Cnil);
#else
			 make_simple_string(sysfun_file));
#endif sgi
	Lload(1, VALUES(0));
}

/* So that the are not placed before init_compiler */
static char *data_file_name = "compiler.data";
static char *sysfun_file = "sysfun.lsp";
