/*
    lex.h -- Lexical environment.
*/
/*
    Copyright (c) 1984, Taiichi Yuasa and Masami Hagiya.
    Copyright (c) 1990, Giuseppe Attardi.

    ECoLisp is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    See file '../Copyright' for full details.
*/



#ifdef MTCL
#define lex_env       clwp->lwp_lex_env
#else
extern object *lex_env;
#endif

extern object Sfunction;
extern object Smacro;
extern object Sblock;


/*

		|---------------|
lex_env ------> |    lex-var	|	: lex_env[0]
		|---------------|
		|    lex-fd	|       : lex_env[1]
		|---------------|
		|    lex-tag	|       : lex_env[2]
		|---------------|

	lex-var:        (symbol value)      	; for local binding
		  (....	   or          ....)
			(symbol)                ; for special binding

	lex-fd:         (fun-name 'FUNCTION'   function)
		  (....		or				...)
			(macro-name 'MACRO' expansion-function)

	lex-tag:  	(tag    'TAG'  	frame-id)
		  (....		or                    ....)
			(block-name 'BLOCK' frame-id)

where 'FUN' is the LISP symbol with pname FUN, etc.


*/

#define lex_dcl		object lex[3]

#define lex_copy()	ihs_top->ihs_base = lex;  \
			lex[0] = lex_env[0];  \
                  	lex[1] = lex_env[1];  \
                  	lex[2] = lex_env[2];  \
			lex_env = lex

#define lex_new()	ihs_top->ihs_base = lex_env = lex;  \
			lex[0] = lex[1] = lex[2] = Cnil
#define lex_var_sch(name)	assoc_eq((name),lex_env[0])

#define lex_fd_sch(name)	assoc_eq((name),lex_env[1])

