%============================================================
% Predicate: library_includes/2
% Modes: library_includes(LibName,+IncludeList)
% 
% Purpose: IncludeList is a list of files that are loaded
%	   by the library. This predicate does the actual 
%	   work of loading them, as well as creating a
%	   dynamic database entry lib_includes(libname,IncludeList)
%	   that is used by the library maintenance.
% 
% Licensed Use: 
% 
% Created: 17-Feb-93
% Last Update: 
%============================================================


library_includes(LibName,IncludeList) :-
	retractall(lib_includes(LibName,_)),
	assert(lib_includes(LibName,IncludeList)),
	library_includes(IncludeList).

library_includes([]) :- !.
library_includes([H|T]) :-
	ensure_loaded(library(H)),
	library_includes(T).

%============================================================
% Predicate: library_dependencies/2
% Modes: library_dependences(+LibName,+DepList)
% 
% Purpose: Strange, does almost the same thing as 
%	   library_includes, except dependencies
%	   can include other libraries (and hope
%	   to God there's no cyclic calls).
% 
% Licensed Use: 
% 
% Created: 17-Feb-93
% Last Update: 
%============================================================

library_dependencies(LibName,DepList) :-
	retractall(lib_dependencies(LibName,_)),
	assert(lib_dependencies(LibName,DepList)),
	library_dependencies(DepList).

library_dependencies([]) :- !.
library_dependencies([H|T]) :-
	nofileerrors,
	ensure_loaded(library(H)),!,
	library_dependencies(T).
library_dependencies([H|T]) :-
	user_library(H),
	library_dependencies(T).

%============================================================
% Predicate: library_publics/2
% Modes: library_dependences(+LibName,+PredSpecs)
% 
% Purpose:
% 
% Licensed Use: 
% 
% Created: 17-Feb-93
% Last Update: 
%============================================================

library_publics(LibName,PredSpecs) :-
	retractall(lib_publics(LibName,_)),
	assert(lib_publics(LibName,PredSpecs)).

%============================================================
% Predicate: library_description/2
% Modes: library_description(+LibName,+Desc)
% 
% Purpose: Desc is a brief description of the library
% 
% Licensed Use: 
% 
% Created: 17-Feb-93
% Last Update: 
%============================================================

library_description(LibName,Desc) :-
	retractall(lib_synopsis(LibName,_)),
	assert(lib_synopsis(LibName,Desc)).

