/*  append_n(L1, L2) iff L1 is a list of lists, which, if concatenated,    */
/*  is L2.  When L1 is var, no null lists are generated for it, even       */
/*  though logically they could appear anywhere.  Thus, this isn't         */
/*  symmetric, in that L1=[[],[1]] will generate L2=[1], but not           */
/*  vice-versa.  Note especially that L1=[[]] will generate L2=[], but     */
/*  not the reverse.  L1 and L2 can be partially instantiated, and this    */
/*  usually works.  NG if both args are var.                               */

/* avoid generating the null list in arg1.                                 */

append_n([List1], List2) :-
  not((var(List1), List2 == [])),
  List1=List2.

append_n([SL1, SL2 | Rest], List) :-
  (var(SL1) -> V=t; V=f),
  append(SL1, Right_part, List),
  not((V=t, SL1=[])),
  append_n([SL2 | Rest], Right_part).

