%============================================================
% Predicate: map/3
% Modes: map(+Pred(...X...),-X,+List)
% 
% Purpose: For each member of List, call Pred(...X...) where
%	   X is the member in question. For example,
%	    map(write(X),X,[a,b,c,d,e]).
%	   would write each element of the list to the output
%	   stream.
% 
% Licensed Use: 
% 
% Created: 11-Feb-93
% Last Update: 
%============================================================

map(_,_,[]).

map(P,Arg,[Arg]) :- 
    !,P.

map(_,_,Var) :- 
    var(Var),!. /*  in case of tail variable */

map(P,Arg,[Arg|_]) :- 
    P,fail.

map(P,Arg,[_|Args]) :- 
    map(P,Arg,Args).

