
%============================================================
% Predicate: readword/1
% Modes: readword(+List)
% 
% Purpose: List is a string of printable characters read from
%	   the input stream
% 
% Licensed Use: 
% 
% Created: 16-Feb-93
% Last Update: 
%============================================================


readword([A|B]) :-
        first_char(A),
        rest_word(B).


first_char(A) :-
        get0(B),
        (   graphic(B) ->
            A=B
        ;   first_char(A)
        ).

rest_word(A) :-
        get0(B),
        (   graphic(B) ->
            A=[B|C],
            rest_word(C)
        ;   A=[]
        ).

graphic(A) :-
        A>32,
        A<128.

