%============================================================
% Predicate: substnvar/4
% Modes: substnvar(+Term1,+List1,?Term,?List2)
% 
% Purpose: List2 is the same as List1 except that every occurence
%	   of Term1 in List1 is replaced by Term2 in List2.
% 
% Licensed Use: substnvar(+Term1,+List1,?Term,?List2)
%
% 
% Created: 11-Feb-93
% Last Update: 
%============================================================

substnvar(_,[],_,[]).

substnvar(X,[Tmp|L],A,[A|M]) :- 
	nonvar(Tmp),Tmp=X,!,
	substnvar(X,L,A,M).

substnvar(X,[Y|L],A,[Y|M]) :- 
	substnvar(X,L,A,M).

