
%============================================================
% Predicate: file_predicates/1
% Modes: file_predicates(+SrcFile)
% 
% Purpose: write each interpreted predicate to a different
%	   file. The name of the file is the predicate name
%	   with _Arity.pl concatenated to it, where Arity
%	   is the arity of the predicate.
% 
% Licensed Use: 
% 
% Created: 16-Feb-93
% Last Update: 
%============================================================

file_predicates(SrcFile) :-
	absolute_file_name(library(SrcFile),AFN),
	source_file(H,AFN),
	current_predicate(P,H),
	functor(H,P,A),
	name(P,FileH),
	name(A,FileArity),
	append_n([FileH,[95],FileArity,[46,112,108]],File),
	name(FileName,File),
	write('writing '),write(P/A),write(' to '),write(FileName),nl,
	tell(FileName),
	listing(P/A),
	told,fail.
	

file_predicates(_).

%============================================================
% Predicate: dummy_start/0
% Modes: 
% 
% Purpose: 
% 
% Licensed Use: 
% 
% Created: 17-Feb-93
% Last Update: 
%============================================================
dummy_start :-
	save(filer),
	unix(argv(L)),!,
	dummy(L).

dummy([]) :- halt.
dummy([H|T]) :-
	[library(H)],
	file_predicates(H),!,
	dummy(T).
	
append_n([List1], List2) :-
  not((var(List1), List2 == [])),
  List1=List2.

append_n([SL1, SL2 | Rest], List) :-
  (var(SL1) -> V=t; V=f),
  append(SL1, Right_part, List),
  not((V=t, SL1=[])),
  append_n([SL2 | Rest], Right_part).


not(P) :- \+ P.

%============================================================
% Predicate: append/3
% Modes: append(?List1,?List2,?List3)
% 
% Purpose: concatenate List1 and List2 to give List3
%	   Lists are all normal.
% 
% Licensed Use: append(+List1,+List2,?List3)
%               append(+List1,-List2,+List3)
%               append(-List1,+List2,+List3)
% 
% Created: 10-Feb-93
% Last Update: 
%============================================================

append([],L3,L3).

append([H1|T1],L2,[H1|T3]) :-
	append(T1,L2,T3).

