/*******************************************************************
**                                                                **
**                    Genetic Library                             **
**                                                                **
**   A library of functions to give an environment for Genetic    **
**                      Algorithms.                               **
**                                                                **
**  While these functions were designed to be used in the field   **
**  of neural networks, they could easily (hopefully) be used on  **
**   other types of optimisations.  The library implements both   **
**   a 1-stage GA and a 2-stage GA. A one stage GA is a GA where  **
**   you only have one population, in a 2-stage GA you may have   **
**  several populations, and a "master" population wich controls  **
**                 the "sub" poulations.                          **
**                                                                **
**        This library has been implemented and tested on:        **
**                                                                **
**           IBM RS/6000 & AIX 3.2 & GCC 2.5.7                    **
**                                                                **
**                 PC & DOS 6.2 % MSC 7.0                         **
**                                                                **
**   This software is part of my Diplomarbeit at the University   **
**  Kassel, Researchgroup Neural Networks.  The software may be   **
**   used for academic and educational purposes.  The use in a    **
**   corporate environment depends on the written permission of   **
**   the author.  I give no warranty for the functions in this    **
**        library, although all have been tested.                 **
**                                                                **
**      You may alter the files in this library, but are not      **
**    permitted to redistribute the files under their original    **
**  name.  If you write additions to this library and would like  **
**    them to be included in future releases, contact me, I'll    **
**           include them and give you credit.                    **
**                                                                **
**      Send questions, bugs, requests for new features and       **
**                      additions to                              **
**                                                                **
**         jochenr@neuro.informatik.uni-kassel.de                 **
**                   University Kassel                            **
**                 FG Neuronale Netzwerke                         **
**                     Jochen Ruhland                             **
**                Heinrich-Plett-Str.  40                         **
**                     D-34132 Kassel                             **
**                        Germany                                 **
**                                                                **
*******************************************************************/
/*****************************************************************************
*                                                                            *
*       Fehlerkurven bei Genetischem cos in Abhngigkeit von div. Parametern *
*                                                                            *
*       (c) Jochen Ruhland                                                   *
*                                                                            *
*       Version 1.0 vom 13.5.1994        erstes Design                        *
*                                                                            *
*****************************************************************************/
 
#include <stdio.h>
#include <time.h>
#include <math.h>

#ifndef _MSDOS
#define __cdecl
#endif

#include "genetic_.h"

#include "../genetic.lib/rlist.h"
#include "../genetic.lib/genops.h"
#include "../genetic.lib/support.h"
#include "../genetic.lib/cmdargs.h"
#include "../genetic.lib/portrnd.h"

/* Globale Variablen */
int pop_size=20;
float p_of_cross=(float)0.5;
int stepsize=4;
float p_mutate=(float)0.1,schranke=(float)0.1;
int use_penalty=0;
int gnuplot_output=0;

struct pararray p_array[MAX_PARAMS] = {
{ 'p', P_NOCASEPAR, P_INT, (void *)&pop_size },
{ 'c', P_NOCASEPAR, P_FLOAT, (void *)&p_of_cross },
{ 'm', P_NOCASEPAR, P_FLOAT, (void *)&p_mutate },
{ 's', P_NOCASEPAR, P_FLOAT, (void *)&schranke },
{ 't', P_NOCASEPAR, P_INT, (void *)&stepsize },
{ 'g', P_NOCASEPAR, P_BOOLEAN_OFF, (void*)&gnuplot_output },
{ 'u', P_NOCASEPAR,P_BOOLEAN_OFF, (void*)&use_penalty }
};
int def_parameter=sizeof( p_array );

/*
	Programmparameter:
		-p pop_size		[20]
		-c p_of_cross		[0.5]
		-m p_mutate		[0.1]
		-s schranke		[0.1]
		-t stepsize		[4]
		-g gnuplot_output [off]
		-u use_penalty [off]
	wenn gnuplot_output ==off
Jeden stepsize-ten Rechenschritt wird ein Zwischenstand ausgegeben, insgesamt
werden 750 Werte erzeugt.
	ansonsten
es wird jeden stepsize-ten Rechenschritt wird ein Zwischenstand auf stderr ausgegeben,
am Ende wird ueber stdout eine gnuplot-Befehlskette ausgegeben.
	wenn use_penalty ==on
danmn kommt der 0.5 malus im error dazu
*/

void dump_params()
{
	FILE *output;
	if( gnuplot_output )
		output = stdout;
	else
		output = stderr;
	fprintf( output,"pop_size\t%d\np_of_cross\t%f\np_mutate\t%f\nstepsize\t%d\n",
			pop_size,p_of_cross,p_mutate,stepsize );
	fprintf( output,(use_penalty?"use_penalty\t"PENALTY_STR"\n":"FALSE\n") );

}
#pragma warning( disable : 4001 )

void gnuplot()
{
	struct popelem *p;
	int i;
	printf( "sig(x) = 1 / (1+exp(-x))\n" );
	p = (struct popelem *)get_population()[0].p;
	for( i=0; i<H_LAYER; i++ )
	{
		printf( "n%d(x)=sig(x*%f+%f)\n",i,POP_FLOAT(p->flayer[0][i]),POP_FLOAT(p->blayer[i]) );
	}
	printf( "net(x)=sig(" );
	for( i=0; i<H_LAYER; i++ )
	{
		if( i )
			printf( "+" );
		printf( "n%d(x)*%f", i,POP_FLOAT(p->llayer[i][0]) );
		if( (i&3)==3 )
			printf( "\\\n" );
	}
	printf( "+%f)\n",POP_FLOAT(p->Blayer[0]) );
	printf( "plot [-1.0: %f] net(x), %s,\\\n\"datapoint.cos\" title \"Cosinus Approximation\" \n",2.0*M_PI+1.0,target_func );
}

int __cdecl main( int argc, char **argv)
{                                         
	USHORT j;
	float merr;
	FILE *outfile;
	unsigned long int maxnr;
	set_target();
	parse_parameter( argc, argv );
	if( gnuplot_output )
		outfile = stderr;
	else
		outfile = stdout;
	init_population( pop_size,  sizeof(struct popelem), time_seed() );
	maxnr = stepsize * 750;
	for( j=0 ; j<maxnr; j++ )
	{
		merr = genstep_cn( ges_error, targets, p_of_cross, p_mutate );
		if( (j%stepsize) == 0 )
		{
			fprintf( outfile,"%d:%13.8f\n",j,merr );
		}
	}
	dump_params();
	if( gnuplot_output )
		gnuplot();
	{
		FILE *out;
		out = fopen( "data.out","w" );
		plot_error(  (struct popelem *)get_population()[0].p, targets, out );
		fclose( out );
	}
	return 0;
}

